/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.processors.datastructures.AtomicDataStructureProxy;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchEx;
import org.apache.ignite.internal.processors.datastructures.GridCacheCountDownLatchValue;
import org.apache.ignite.internal.processors.datastructures.GridCacheInternalKey;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;

public final class GridCacheCountDownLatchImpl
extends AtomicDataStructureProxy<GridCacheCountDownLatchValue>
implements GridCacheCountDownLatchEx,
IgniteChangeGlobalStateSupport,
Externalizable {
    private static final long serialVersionUID = 0L;
    private static final int UNINITIALIZED_LATCH_STATE = 0;
    private static final int CREATING_LATCH_STATE = 1;
    private static final int READY_LATCH_STATE = 2;
    private static final ThreadLocal<IgniteBiTuple<GridKernalContext, String>> stash = new ThreadLocal<IgniteBiTuple<GridKernalContext, String>>(){

        @Override
        protected IgniteBiTuple<GridKernalContext, String> initialValue() {
            return new IgniteBiTuple<GridKernalContext, String>();
        }
    };
    private int initCnt;
    private boolean autoDel;
    private CountDownLatch internalLatch;
    private final AtomicInteger initGuard = new AtomicInteger();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private Integer lastLatchVal = null;

    public GridCacheCountDownLatchImpl() {
    }

    public GridCacheCountDownLatchImpl(String name, int initCnt, boolean autoDel, GridCacheInternalKey key, IgniteInternalCache<GridCacheInternalKey, GridCacheCountDownLatchValue> latchView) {
        super(name, key, latchView);
        assert (name != null);
        assert (key != null);
        assert (latchView != null);
        this.initCnt = initCnt;
        this.autoDel = autoDel;
    }

    @Override
    public int count() {
        try {
            GridCacheCountDownLatchValue latchVal = (GridCacheCountDownLatchValue)this.cacheView.get(this.key);
            return latchVal == null ? 0 : latchVal.get();
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public int initialCount() {
        return this.initCnt;
    }

    @Override
    public boolean autoDelete() {
        return this.autoDel;
    }

    @Override
    public void await() {
        try {
            this.initializeLatch();
            U.await(this.internalLatch);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        try {
            this.initializeLatch();
            return U.await(this.internalLatch, timeout, unit);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public boolean await(long timeout) {
        return this.await(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int countDown() {
        return this.countDown(1);
    }

    @Override
    public int countDown(int val) {
        A.ensure(val > 0, "val should be positive");
        try {
            return CU.retryTopologySafe(new CountDownCallable(val));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void countDownAll() {
        try {
            CU.retryTopologySafe(new CountDownCallable(0));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public void needCheckNotRemoved() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(int cnt) {
        CountDownLatch latch0;
        assert (cnt >= 0);
        AtomicInteger atomicInteger = this.initGuard;
        synchronized (atomicInteger) {
            int state = this.initGuard.get();
            if (state != 2) {
                this.lastLatchVal = cnt;
                return;
            }
            latch0 = this.internalLatch;
        }
        assert (latch0 != null);
        while (latch0.getCount() > (long)cnt) {
            latch0.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeLatch() throws IgniteCheckedException {
        if (this.initGuard.compareAndSet(0, 1)) {
            try {
                this.internalLatch = CU.retryTopologySafe(new Callable<CountDownLatch>(){

                    @Override
                    public CountDownLatch call() throws Exception {
                        try (GridNearTxLocal tx = CU.txStartInternal(GridCacheCountDownLatchImpl.this.ctx, GridCacheCountDownLatchImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                            GridCacheCountDownLatchValue val = (GridCacheCountDownLatchValue)GridCacheCountDownLatchImpl.this.cacheView.get(GridCacheCountDownLatchImpl.this.key);
                            if (val == null) {
                                if (GridCacheCountDownLatchImpl.this.log.isDebugEnabled()) {
                                    GridCacheCountDownLatchImpl.this.log.debug("Failed to find count down latch with given name: " + GridCacheCountDownLatchImpl.this.name);
                                }
                                CountDownLatch countDownLatch = new CountDownLatch(0);
                                return countDownLatch;
                            }
                            tx.commit();
                            CountDownLatch countDownLatch = new CountDownLatch(val.get());
                            return countDownLatch;
                        }
                    }
                });
                AtomicInteger atomicInteger = this.initGuard;
                synchronized (atomicInteger) {
                    if (this.lastLatchVal != null) {
                        while (this.internalLatch.getCount() > (long)this.lastLatchVal.intValue()) {
                            this.internalLatch.countDown();
                        }
                    }
                    this.initGuard.set(2);
                }
                if (!this.log.isDebugEnabled()) return;
                this.log.debug("Initialized internal latch: " + this.internalLatch);
                return;
            }
            finally {
                this.initLatch.countDown();
            }
        }
        U.await(this.initLatch);
        if (this.internalLatch != null) return;
        throw new IgniteCheckedException("Internal latch has not been properly initialized.");
    }

    @Override
    public void close() {
        if (!this.rmvd) {
            try {
                this.ctx.kernalContext().dataStructures().removeCountDownLatch(this.name, this.ctx.group().name());
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx.kernalContext());
        out.writeUTF(this.name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IgniteBiTuple<GridKernalContext, String> t = stash.get();
        t.set1((GridKernalContext)in.readObject());
        t.set2(in.readUTF());
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            IgniteBiTuple<GridKernalContext, String> t = stash.get();
            IgniteCountDownLatch igniteCountDownLatch = t.get1().dataStructures().countDownLatch(t.get2(), null, 0, false, false);
            return igniteCountDownLatch;
        }
        catch (IgniteCheckedException e) {
            throw U.withCause(new InvalidObjectException(e.getMessage()), e);
        }
        finally {
            stash.remove();
        }
    }

    public String toString() {
        return S.toString(GridCacheCountDownLatchImpl.class, this);
    }

    private class CountDownCallable
    implements Callable<Integer> {
        private final int val;

        private CountDownCallable(int val) {
            assert (val >= 0);
            this.val = val;
        }

        @Override
        public Integer call() throws Exception {
            try (GridNearTxLocal tx = CU.txStartInternal(GridCacheCountDownLatchImpl.this.ctx, GridCacheCountDownLatchImpl.this.cacheView, TransactionConcurrency.PESSIMISTIC, TransactionIsolation.REPEATABLE_READ);){
                int retVal;
                GridCacheCountDownLatchValue latchVal = (GridCacheCountDownLatchValue)GridCacheCountDownLatchImpl.this.cacheView.get(GridCacheCountDownLatchImpl.this.key);
                if (latchVal == null) {
                    if (GridCacheCountDownLatchImpl.this.log.isDebugEnabled()) {
                        GridCacheCountDownLatchImpl.this.log.debug("Failed to find count down latch with given name: " + GridCacheCountDownLatchImpl.this.name);
                    }
                    Integer n = 0;
                    return n;
                }
                if (this.val > 0) {
                    retVal = latchVal.get() - this.val;
                    if (retVal < 0) {
                        retVal = 0;
                    }
                } else {
                    retVal = 0;
                }
                latchVal.set(retVal);
                GridCacheCountDownLatchImpl.this.cacheView.put(GridCacheCountDownLatchImpl.this.key, latchVal);
                tx.commit();
                Integer n = retVal;
                return n;
            }
        }
    }
}

