/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteTooManyOpenFilesException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.GridManager;
import org.apache.ignite.internal.managers.tracing.GridTracingManager;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.tracing.Tracing;
import org.apache.ignite.internal.util.GridConcurrentFactory;
import org.apache.ignite.internal.util.IgniteExceptionRegistry;
import org.apache.ignite.internal.util.function.ThrowableBiFunction;
import org.apache.ignite.internal.util.function.ThrowableSupplier;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.nio.GridConnectionBytesVerifyFilter;
import org.apache.ignite.internal.util.nio.GridDirectParser;
import org.apache.ignite.internal.util.nio.GridNioCodecFilter;
import org.apache.ignite.internal.util.nio.GridNioFilter;
import org.apache.ignite.internal.util.nio.GridNioFilterAdapter;
import org.apache.ignite.internal.util.nio.GridNioMessageReaderFactory;
import org.apache.ignite.internal.util.nio.GridNioMessageWriterFactory;
import org.apache.ignite.internal.util.nio.GridNioRecoveryDescriptor;
import org.apache.ignite.internal.util.nio.GridNioServer;
import org.apache.ignite.internal.util.nio.GridNioServerListener;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.nio.GridNioSessionMetaKey;
import org.apache.ignite.internal.util.nio.GridNioTracerFilter;
import org.apache.ignite.internal.util.nio.GridSelectorNioSessionImpl;
import org.apache.ignite.internal.util.nio.GridTcpNioCommunicationClient;
import org.apache.ignite.internal.util.nio.ssl.GridNioSslFilter;
import org.apache.ignite.internal.util.nio.ssl.GridSslMeta;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteBiInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.spi.ExponentialBackoffTimeoutStrategy;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiOperationTimeoutException;
import org.apache.ignite.spi.communication.CommunicationListener;
import org.apache.ignite.spi.communication.tcp.AttributeNames;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.internal.ClusterStateProvider;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationListenerEx;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationTcpUtils;
import org.apache.ignite.spi.communication.tcp.internal.CommunicationWorker;
import org.apache.ignite.spi.communication.tcp.internal.ConnectGateway;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionClientPool;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionKey;
import org.apache.ignite.spi.communication.tcp.internal.ConnectionPolicy;
import org.apache.ignite.spi.communication.tcp.internal.HandshakeTimeoutObject;
import org.apache.ignite.spi.communication.tcp.internal.NodeUnreachableException;
import org.apache.ignite.spi.communication.tcp.internal.TcpCommunicationConfiguration;
import org.apache.ignite.spi.communication.tcp.internal.TcpHandshakeExecutor;
import org.apache.ignite.spi.communication.tcp.messages.HandshakeMessage;
import org.apache.ignite.spi.communication.tcp.messages.HandshakeMessage2;
import org.apache.ignite.spi.communication.tcp.messages.RecoveryLastReceivedMessage;
import org.apache.ignite.spi.discovery.IgniteDiscoveryThread;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.jetbrains.annotations.Nullable;

public class GridNioServerWrapper {
    private static final int DFLT_INITIAL_TIMEOUT = 500;
    private static final int DFLT_NEED_WAIT_DELAY = 200;
    private static final int DFLT_RECONNECT_DELAY = 50;
    static final int CHANNEL_FUT_META = GridNioSessionMetaKey.nextUniqueKey();
    static final int MAX_CONN_PER_NODE = 1024;
    private final IgniteLogger log;
    private final TcpCommunicationConfiguration cfg;
    private final AttributeNames attrs;
    private final Tracing tracing;
    private final Function<UUID, ClusterNode> nodeGetter;
    private final Supplier<ClusterNode> locNodeSupplier;
    private final ConnectGateway connectGate;
    private final ClusterStateProvider stateProvider;
    private final Supplier<IgniteExceptionRegistry> eRegistrySupplier;
    private final IgniteConfiguration igniteCfg;
    private final GridNioServerListener<Message> srvLsnr;
    private final String igniteInstanceName;
    private final WorkersRegistry workersRegistry;
    private final GridMetricManager metricMgr;
    private final ThrowableBiFunction<ClusterNode, Integer, GridCommunicationClient, IgniteCheckedException> createTcpClientFun;
    private final ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> recoveryDescs = GridConcurrentFactory.newMap();
    private final ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> outRecDescs = GridConcurrentFactory.newMap();
    private final ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> inRecDescs = GridConcurrentFactory.newMap();
    private final CommunicationListener<Message> lsnr;
    private volatile CommunicationWorker commWorker;
    private volatile ThrowableSupplier<SocketChannel, IOException> socketChannelFactory = SocketChannel::open;
    private boolean forcibleNodeKillEnabled = IgniteSystemProperties.getBoolean("IGNITE_ENABLE_FORCIBLE_NODE_KILL");
    private GridNioServer<Message> nioSrv;
    private volatile boolean stopping = false;
    private ConnectionPolicy chConnPlc;
    private final ScheduledExecutorService handshakeTimeoutExecutorService;
    private final TcpHandshakeExecutor tcpHandshakeExecutor;

    public GridNioServerWrapper(IgniteLogger log, TcpCommunicationConfiguration cfg, AttributeNames attributeNames, Tracing tracing, Function<UUID, ClusterNode> nodeGetter, Supplier<ClusterNode> locNodeSupplier, ConnectGateway connectGate, ClusterStateProvider stateProvider, Supplier<IgniteExceptionRegistry> eRegistrySupplier, CommunicationWorker commWorker, IgniteConfiguration igniteCfg, GridNioServerListener<Message> srvLsnr, String igniteInstanceName, WorkersRegistry workersRegistry, @Nullable GridMetricManager metricMgr, ThrowableBiFunction<ClusterNode, Integer, GridCommunicationClient, IgniteCheckedException> createTcpClientFun, CommunicationListener<Message> lsnr, TcpHandshakeExecutor tcpHandshakeExecutor) {
        this.log = log;
        this.cfg = cfg;
        this.attrs = attributeNames;
        this.tracing = tracing;
        this.nodeGetter = nodeGetter;
        this.locNodeSupplier = locNodeSupplier;
        this.connectGate = connectGate;
        this.stateProvider = stateProvider;
        this.eRegistrySupplier = eRegistrySupplier;
        this.commWorker = commWorker;
        this.igniteCfg = igniteCfg;
        this.srvLsnr = srvLsnr;
        this.igniteInstanceName = igniteInstanceName;
        this.workersRegistry = workersRegistry;
        this.metricMgr = metricMgr;
        this.createTcpClientFun = createTcpClientFun;
        this.lsnr = lsnr;
        this.chConnPlc = new ConnectionPolicy(){
            private final AtomicInteger chIdx = new AtomicInteger(1025);

            @Override
            public int connectionIndex() {
                return this.chIdx.incrementAndGet();
            }
        };
        this.tcpHandshakeExecutor = tcpHandshakeExecutor;
        this.handshakeTimeoutExecutorService = Executors.newSingleThreadScheduledExecutor(new IgniteThreadFactory(igniteInstanceName, "handshake-timeout-nio"));
    }

    public void start() {
        this.nioSrv.start();
    }

    public void stop() {
        if (this.nioSrv != null) {
            this.nioSrv.stop();
        }
        this.stopping = true;
        this.handshakeTimeoutExecutorService.shutdown();
    }

    public void clear() {
        this.nioSrv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridNioSession createNioSession(ClusterNode node, int connIdx) throws IgniteCheckedException {
        boolean locNodeIsSrv;
        boolean bl = locNodeIsSrv = !this.locNodeSupplier.get().isClient();
        if (!(Thread.currentThread() instanceof IgniteDiscoveryThread) && locNodeIsSrv && node.isClient() && this.forceClientToServerConnections(node)) {
            String msg = "Failed to connect to node " + node.id() + " because it is started in 'forceClientToServerConnections' mode; inverse connection will be requested.";
            throw new NodeUnreachableException(msg);
        }
        Collection<InetSocketAddress> addrs = CommunicationTcpUtils.nodeAddresses(node, this.cfg.filterReachableAddresses(), this.attrs, this.locNodeSupplier);
        GridNioSession ses = null;
        IgniteCheckedException errs = null;
        long totalTimeout = this.cfg.failureDetectionTimeoutEnabled() ? (node.isClient() ? this.stateProvider.clientFailureDetectionTimeout() : this.cfg.failureDetectionTimeout()) : ExponentialBackoffTimeoutStrategy.totalBackoffTimeout(this.cfg.connectionTimeout(), this.cfg.maxConnectionTimeout(), this.cfg.reconCount());
        HashSet<InetSocketAddress> failedAddrsSet = new HashSet<InetSocketAddress>();
        int skippedAddrs = 0;
        for (InetSocketAddress addr : addrs) {
            if (addr.isUnresolved()) {
                failedAddrsSet.add(addr);
                continue;
            }
            ExponentialBackoffTimeoutStrategy connTimeoutStgy = new ExponentialBackoffTimeoutStrategy(totalTimeout, this.cfg.failureDetectionTimeoutEnabled() ? 500L : this.cfg.connectionTimeout(), this.cfg.maxConnectionTimeout());
            while (ses == null) {
                CommunicationWorker commWorker0;
                block54: {
                    String msg;
                    if (this.stopping) {
                        throw new IgniteSpiException("Node is stopping.");
                    }
                    if (this.isLocalNodeAddress(addr)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Skipping local address [addr=" + addr + ", locAddrs=" + node.attribute(this.attrs.addresses()) + ", node=" + node + "]");
                        }
                        ++skippedAddrs;
                        break;
                    }
                    long timeout = 0L;
                    this.connectGate.enter();
                    try {
                        if (this.nodeGetter.apply(node.id()) == null) {
                            throw new ClusterTopologyCheckedException("Failed to send message (node left topology): " + node);
                        }
                        SocketChannel ch = this.socketChannelFactory.get();
                        ch.configureBlocking(true);
                        ch.socket().setTcpNoDelay(this.cfg.tcpNoDelay());
                        ch.socket().setKeepAlive(true);
                        if (this.cfg.socketReceiveBuffer() > 0) {
                            ch.socket().setReceiveBufferSize(this.cfg.socketReceiveBuffer());
                        }
                        if (this.cfg.socketSendBuffer() > 0) {
                            ch.socket().setSendBufferSize(this.cfg.socketSendBuffer());
                        }
                        ConnectionKey connKey = new ConnectionKey(node.id(), connIdx, -1L);
                        GridNioRecoveryDescriptor recoveryDesc = this.outRecoveryDescriptor(node, connKey);
                        assert (recoveryDesc != null) : "Recovery descriptor not found [connKey=" + connKey + ", rmtNode=" + node.id() + "]";
                        if (!recoveryDesc.reserve()) {
                            U.closeQuiet(ch);
                            GridNioSession sesFromRecovery = recoveryDesc.session();
                            if (sesFromRecovery != null) {
                                while (sesFromRecovery.closeTime() == 0L) {
                                    sesFromRecovery.close();
                                }
                            }
                            GridNioSession gridNioSession = null;
                            return gridNioSession;
                        }
                        HashMap<Integer, Object> meta = new HashMap<Integer, Object>();
                        GridSslMeta sslMeta = null;
                        try {
                            ClusterNode locNode;
                            timeout = connTimeoutStgy.nextTimeout();
                            ch.socket().connect(addr, (int)timeout);
                            if (this.nodeGetter.apply(node.id()) == null) {
                                throw new ClusterTopologyCheckedException("Failed to send message (node left topology): " + node);
                            }
                            if (this.stateProvider.isSslEnabled()) {
                                sslMeta = new GridSslMeta();
                                meta.put(GridNioSessionMetaKey.SSL_META.ordinal(), sslMeta);
                                SSLEngine sslEngine = this.stateProvider.createSSLEngine();
                                sslEngine.setUseClientMode(true);
                                sslMeta.sslEngine(sslEngine);
                            }
                            if ((locNode = this.locNodeSupplier.get()) == null) {
                                throw new IgniteCheckedException("Local node has not been started or fully initialized [isStopping=" + this.stateProvider.isStopping() + "]");
                            }
                            timeout = connTimeoutStgy.nextTimeout(timeout);
                            long rcvCnt = this.safeTcpHandshake(ch, node.id(), timeout, sslMeta, new HandshakeMessage2(locNode.id(), recoveryDesc.incrementConnectCount(), recoveryDesc.received(), connIdx));
                            if (rcvCnt == -1L) {
                                GridNioSession gridNioSession = null;
                                return gridNioSession;
                            }
                            if (rcvCnt == -2L) {
                                throw new ClusterTopologyCheckedException("Remote node started stop procedure: " + node.id());
                            }
                            if (rcvCnt == -4L) {
                                throw new IgniteCheckedException("Remote node does not observe current node in topology : " + node.id());
                            }
                            if (rcvCnt == -3L) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("NEED_WAIT received, handshake after delay [node = " + node + ", outOfTopologyDelay = 200ms]");
                                }
                                U.sleep(200L);
                                continue;
                            }
                            if (rcvCnt < 0L) {
                                throw new IgniteCheckedException("Unsupported negative receivedCount [rcvCnt=" + rcvCnt + ", senderNode=" + node + "]");
                            }
                            recoveryDesc.onHandshake(rcvCnt);
                            meta.put(TcpCommunicationSpi.CONSISTENT_ID_META, node.consistentId());
                            meta.put(TcpCommunicationSpi.CONN_IDX_META, connKey);
                            meta.put(GridNioServer.RECOVERY_DESC_META_KEY, recoveryDesc);
                            ses = (GridNioSession)this.nioSrv.createSession(ch, meta, false, null).get();
                        }
                        finally {
                            if (ses != null) continue;
                            U.closeQuiet(ch);
                            if (recoveryDesc == null) continue;
                            recoveryDesc.release();
                            continue;
                        }
                    }
                    catch (IgniteSpiOperationTimeoutException e) {
                        if (ses != null) {
                            ses.close();
                            ses = null;
                        }
                        this.eRegistrySupplier.get().onException("Handshake timed out (will retry with increased timeout) [connTimeoutStrategy=" + connTimeoutStgy + ", addr=" + addr + "]", e);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Handshake timed out (will retry with increased timeout) [connTimeoutStrategy=" + connTimeoutStgy + ", addr=" + addr + ", err=" + e + "]");
                        }
                        if (connTimeoutStgy.checkTimeout()) {
                            U.warn(this.log, "Handshake timed out (will stop attempts to perform the handshake) [node=" + node.id() + ", connTimeoutStrategy=" + connTimeoutStgy + ", err=" + e.getMessage() + ", addr=" + addr + ", failureDetectionTimeoutEnabled=" + this.cfg.failureDetectionTimeoutEnabled() + ", timeout=" + timeout + "]");
                            msg = "Failed to connect to node (is node still alive?). Make sure that each ComputeTask and cache Transaction has a timeout set in order to prevent parties from waiting forever in case of network issues [nodeId=" + node.id() + ", addrs=" + addrs + "]";
                            if (errs == null) {
                                errs = new IgniteCheckedException(msg, e);
                                break;
                            }
                            errs.addSuppressed(new IgniteCheckedException(msg, e));
                            break;
                        }
                    }
                    catch (ClusterTopologyCheckedException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        if (ses != null) {
                            ses.close();
                            ses = null;
                        }
                        this.eRegistrySupplier.get().onException("Client creation failed [addr=" + addr + ", err=" + e + "]", e);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Client creation failed [addr=" + addr + ", err=" + e + "]");
                        }
                        if (X.hasCause((Throwable)e, "Too many open files", SocketException.class)) {
                            throw new IgniteTooManyOpenFilesException(e);
                        }
                        if (connTimeoutStgy.checkTimeout()) {
                            U.warn(this.log, "Connection timed out (will stop attempts to perform the connect) [node=" + node.id() + ", connTimeoutStgy=" + connTimeoutStgy + ", failureDetectionTimeoutEnabled=" + this.cfg.failureDetectionTimeoutEnabled() + ", timeout=" + timeout + ", err=" + e.getMessage() + ", addr=" + addr + "]");
                            msg = "Failed to connect to node (is node still alive?). Make sure that each ComputeTask and cache Transaction has a timeout set in order to prevent parties from waiting forever in case of network issues [nodeId=" + node.id() + ", addrs=" + addrs + "]";
                            if (errs == null) {
                                errs = new IgniteCheckedException(msg, e);
                                break;
                            }
                            errs.addSuppressed(new IgniteCheckedException(msg, e));
                            break;
                        }
                        if (node.isClient() && this.isNodeUnreachableException(e)) {
                            failedAddrsSet.add(addr);
                        }
                        if (CommunicationTcpUtils.isRecoverableException(e)) {
                            U.sleep(50L);
                            break block54;
                        }
                        msg = "Failed to connect to node due to unrecoverable exception (is node still alive?). Make sure that each ComputeTask and cache Transaction has a timeout set in order to prevent parties from waiting forever in case of network issues [nodeId=" + node.id() + ", addrs=" + addrs + ", err= " + e + "]";
                        if (errs == null) {
                            errs = new IgniteCheckedException(msg, e);
                            break;
                        }
                        errs.addSuppressed(new IgniteCheckedException(msg, e));
                        break;
                    }
                    finally {
                        this.connectGate.leave();
                        continue;
                    }
                }
                if ((commWorker0 = this.commWorker) == null || commWorker0.runner() != Thread.currentThread()) continue;
                commWorker0.updateHeartbeat();
            }
            if (ses == null) continue;
            break;
        }
        if (ses == null) {
            if (!(this.cfg.usePairedConnections() && Boolean.TRUE.equals(node.attribute(this.attrs.pairedConnection())) || Thread.currentThread() instanceof IgniteDiscoveryThread || !locNodeIsSrv || !node.isClient() || addrs.size() - skippedAddrs != failedAddrsSet.size())) {
                String msg = "Failed to connect to all addresses of node " + node.id() + ": " + failedAddrsSet + "; inverse connection will be requested.";
                throw new NodeUnreachableException(msg);
            }
            this.processSessionCreationError(node, addrs, errs == null ? new IgniteCheckedException("No session found") : errs);
        }
        return ses;
    }

    private boolean isNodeUnreachableException(Exception e) {
        return e instanceof NodeUnreachableException || e instanceof SocketTimeoutException;
    }

    public GridCommunicationClient createTcpClient(ClusterNode node, int connIdx, boolean backwardCompatibility) throws IgniteCheckedException {
        if (backwardCompatibility) {
            return this.createTcpClientFun.apply(node, connIdx);
        }
        GridNioSession ses = this.createNioSession(node, connIdx);
        return ses == null ? null : new GridTcpNioCommunicationClient(connIdx, ses, this.log);
    }

    public GridNioServer<Message> nio() {
        return this.nioSrv;
    }

    public void nio(GridNioServer<Message> srv) {
        this.nioSrv = srv;
    }

    public GridNioRecoveryDescriptor inRecoveryDescriptor(ClusterNode node, ConnectionKey key) {
        if (this.cfg.usePairedConnections() && CommunicationTcpUtils.usePairedConnections(node, this.attrs.pairedConnection())) {
            return this.recoveryDescriptor(this.inRecDescs, true, node, key);
        }
        return this.recoveryDescriptor(this.recoveryDescs, false, node, key);
    }

    public ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> recoveryDescs() {
        return this.recoveryDescs;
    }

    public ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> outRecDescs() {
        return this.outRecDescs;
    }

    public ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> inRecDescs() {
        return this.inRecDescs;
    }

    public void processSessionCreationError(ClusterNode node, Collection<InetSocketAddress> addrs, IgniteCheckedException errs) throws IgniteCheckedException {
        assert (errs != null);
        boolean commErrResolve = false;
        IgniteSpiContext ctx = this.stateProvider.getSpiContext();
        if (CommunicationTcpUtils.isRecoverableException(errs) && ctx.communicationFailureResolveSupported()) {
            commErrResolve = true;
            ctx.resolveCommunicationFailure(node, errs);
        }
        if (!commErrResolve && this.forcibleNodeKillEnabled && ctx.node(node.id()) != null && node.isClient() && !this.locNodeSupplier.get().isClient() && CommunicationTcpUtils.isRecoverableException(errs)) {
            CommunicationTcpUtils.failNode(node, ctx, errs, this.log);
        }
        throw errs;
    }

    public GridNioServer<Message> resetNioServer() throws IgniteCheckedException {
        if (this.cfg.boundTcpPort() >= 0) {
            throw new IgniteCheckedException("Tcp NIO server was already created on port " + this.cfg.boundTcpPort());
        }
        IgniteCheckedException lastEx = null;
        int lastPort = this.cfg.localPort() == -1 ? -1 : (this.cfg.localPortRange() == 0 ? this.cfg.localPort() : this.cfg.localPort() + this.cfg.localPortRange() - 1);
        for (int port = this.cfg.localPort(); port <= lastPort; ++port) {
            try {
                MessageFactory msgFactory = new MessageFactory(){
                    private MessageFactory impl;

                    @Override
                    public void register(short directType, Supplier<Message> supplier) throws IgniteException {
                        this.get().register(directType, supplier);
                    }

                    @Override
                    @Nullable
                    public Message create(short type) {
                        return this.get().create(type);
                    }

                    private MessageFactory get() {
                        if (this.impl == null) {
                            this.impl = GridNioServerWrapper.this.stateProvider.getSpiContext().messageFactory();
                            assert (this.impl != null);
                        }
                        return this.impl;
                    }
                };
                GridNioMessageReaderFactory readerFactory = new GridNioMessageReaderFactory(){
                    private IgniteSpiContext context;
                    private MessageFormatter formatter;

                    @Override
                    public MessageReader reader(GridNioSession ses, MessageFactory msgFactory) throws IgniteCheckedException {
                        IgniteSpiContext ctx = GridNioServerWrapper.this.stateProvider.getSpiContextWithoutInitialLatch();
                        if (this.formatter == null || this.context != ctx) {
                            this.context = ctx;
                            this.formatter = this.context.messageFormatter();
                        }
                        assert (this.formatter != null);
                        ConnectionKey key = (ConnectionKey)ses.meta(TcpCommunicationSpi.CONN_IDX_META);
                        return key != null ? this.formatter.reader(key.nodeId(), msgFactory) : null;
                    }
                };
                GridNioMessageWriterFactory writerFactory = new GridNioMessageWriterFactory(){
                    private IgniteSpiContext context;
                    private MessageFormatter formatter;

                    @Override
                    public MessageWriter writer(GridNioSession ses) throws IgniteCheckedException {
                        IgniteSpiContext ctx = GridNioServerWrapper.this.stateProvider.getSpiContextWithoutInitialLatch();
                        if (this.formatter == null || this.context != ctx) {
                            this.context = ctx;
                            this.formatter = this.context.messageFormatter();
                        }
                        assert (this.formatter != null);
                        ConnectionKey key = (ConnectionKey)ses.meta(TcpCommunicationSpi.CONN_IDX_META);
                        return key != null ? this.formatter.writer(key.nodeId()) : null;
                    }
                };
                GridDirectParser parser = new GridDirectParser(this.log.getLogger(GridDirectParser.class), msgFactory, readerFactory);
                IgnitePredicate<Message> skipRecoveryPred = msg -> msg instanceof RecoveryLastReceivedMessage;
                boolean clientMode = Boolean.TRUE.equals(this.igniteCfg.isClientMode());
                IgniteBiInClosure<GridNioSession, Integer> queueSizeMonitor = !clientMode && this.cfg.slowClientQueueLimit() > 0 ? this::checkClientQueueSize : null;
                ArrayList<GridNioFilterAdapter> filters = new ArrayList<GridNioFilterAdapter>();
                if (this.tracing instanceof GridTracingManager && ((GridManager)((Object)this.tracing)).enabled()) {
                    filters.add(new GridNioTracerFilter(this.log, this.tracing));
                }
                filters.add(new GridNioCodecFilter(parser, this.log, true));
                filters.add(new GridConnectionBytesVerifyFilter(this.log));
                if (this.stateProvider.isSslEnabled()) {
                    GridNioSslFilter sslFilter = new GridNioSslFilter((SSLContext)this.igniteCfg.getSslContextFactory().create(), true, ByteOrder.LITTLE_ENDIAN, this.log, this.metricMgr == null ? null : this.metricMgr.registry(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME));
                    sslFilter.directMode(true);
                    sslFilter.wantClientAuth(true);
                    sslFilter.needClientAuth(true);
                    filters.add(sslFilter);
                }
                GridNioServer.Builder<Message> builder = GridNioServer.builder().address(this.cfg.localHost()).port(port).listener(this.srvLsnr).logger(this.log).selectorCount(this.cfg.selectorsCount()).igniteInstanceName(this.igniteInstanceName).serverName("tcp-comm").tcpNoDelay(this.cfg.tcpNoDelay()).directBuffer(this.cfg.directBuffer()).byteOrder(ByteOrder.LITTLE_ENDIAN).socketSendBufferSize(this.cfg.socketSendBuffer()).socketReceiveBufferSize(this.cfg.socketReceiveBuffer()).sendQueueLimit(this.cfg.messageQueueLimit()).directMode(true).writeTimeout(this.cfg.socketWriteTimeout()).selectorSpins(this.cfg.selectorSpins()).filters(filters.toArray(new GridNioFilter[filters.size()])).writerFactory(writerFactory).skipRecoveryPredicate(skipRecoveryPred).messageQueueSizeListener(queueSizeMonitor).tracing(this.tracing).readWriteSelectorsAssign(this.cfg.usePairedConnections());
                if (this.metricMgr != null) {
                    builder.workerListener(this.workersRegistry).metricRegistry(this.metricMgr.registry(TcpCommunicationSpi.COMMUNICATION_METRICS_GROUP_NAME));
                }
                GridNioServer<Message> srvr = builder.build();
                this.cfg.boundTcpPort(port);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Successfully bound communication NIO server to TCP port [port=" + this.cfg.boundTcpPort() + ", locHost=" + this.cfg.localHost() + ", selectorsCnt=" + this.cfg.selectorsCount() + ", selectorSpins=" + srvr.selectorSpins() + ", pairedConn=" + this.cfg.usePairedConnections() + "]");
                }
                srvr.idleTimeout(this.cfg.idleConnectionTimeout());
                return srvr;
            }
            catch (IgniteCheckedException e) {
                if (X.hasCause((Throwable)e, SSLException.class)) {
                    throw new IgniteSpiException("Failed to create SSL context. SSL factory: " + this.igniteCfg.getSslContextFactory() + ".", e);
                }
                lastEx = e;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to bind to local port (will try next port within range) [port=" + port + ", locHost=" + this.cfg.localHost() + "]");
                }
                this.eRegistrySupplier.get().onException("Failed to bind to local port (will try next port within range) [port=" + port + ", locHost=" + this.cfg.localHost() + "]", e);
                continue;
            }
        }
        throw new IgniteCheckedException("Failed to bind to any port within range [startPort=" + this.cfg.localPort() + ", portRange=" + this.cfg.localPortRange() + ", locHost=" + this.cfg.localHost() + "]", lastEx);
    }

    private GridNioRecoveryDescriptor outRecoveryDescriptor(ClusterNode node, ConnectionKey key) {
        if (this.cfg.usePairedConnections() && CommunicationTcpUtils.usePairedConnections(node, this.attrs.pairedConnection())) {
            return this.recoveryDescriptor(this.outRecDescs, true, node, key);
        }
        return this.recoveryDescriptor(this.recoveryDescs, false, node, key);
    }

    private GridNioRecoveryDescriptor recoveryDescriptor(ConcurrentMap<ConnectionKey, GridNioRecoveryDescriptor> recoveryDescs, boolean pairedConnections, ClusterNode node, ConnectionKey key) {
        GridNioRecoveryDescriptor recovery = (GridNioRecoveryDescriptor)recoveryDescs.get(key);
        if (recovery == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Missing recovery descriptor for the node (will create a new one) [locNodeId=" + this.locNodeSupplier.get().id() + ", key=" + key + ", rmtNode=" + node + "]");
            }
            int maxSize = Math.max(this.cfg.messageQueueLimit(), this.cfg.ackSendThreshold());
            int queueLimit = this.cfg.unackedMsgsBufferSize() != 0 ? this.cfg.unackedMsgsBufferSize() : maxSize * 128;
            recovery = new GridNioRecoveryDescriptor(pairedConnections, queueLimit, node, this.log);
            GridNioRecoveryDescriptor old = recoveryDescs.putIfAbsent(key, recovery);
            if (old != null) {
                recovery = old;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Will use existing recovery descriptor: " + recovery);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Initialized recovery descriptor [desc=" + recovery + ", maxSize=" + maxSize + ", queueLimit=" + queueLimit + "]");
            }
        }
        return recovery;
    }

    public void onChannelCreate(GridSelectorNioSessionImpl ses, ConnectionKey connKey, Message msg) {
        this.cleanupLocalNodeRecoveryDescriptor(connKey);
        ses.send(msg).listen(sendFut -> {
            if (sendFut.error() != null) {
                U.error(this.log, "Fail to send channel creation response to the remote node. Session will be closed [nodeId=" + connKey.nodeId() + ", idx=" + connKey.connectionIndex() + "]", sendFut.error());
                ses.close();
                return;
            }
            ses.closeSocketOnSessionClose(false);
            ses.close().listen(closeFut -> {
                if (closeFut.error() != null) {
                    U.error(this.log, "Nio session has not been properly closed [nodeId=" + connKey.nodeId() + ", idx=" + connKey.connectionIndex() + "]", closeFut.error());
                    U.closeQuiet(ses.key().channel());
                    return;
                }
                this.notifyChannelEvtListener(connKey.nodeId(), ses.key().channel(), msg);
            });
        });
    }

    public IgniteInternalFuture<Channel> openChannel(ClusterNode remote, Message initMsg) throws IgniteSpiException {
        assert (!remote.isLocal()) : remote;
        assert (initMsg != null);
        assert (this.chConnPlc != null);
        ConnectionKey key = new ConnectionKey(remote.id(), this.chConnPlc.connectionIndex());
        GridFutureAdapter<Channel> chFut = new GridFutureAdapter<Channel>();
        this.connectGate.enter();
        try {
            GridNioSession ses = this.createNioSession(remote, key.connectionIndex());
            assert (ses != null) : "Session must be established [remoteId=" + remote.id() + ", key=" + key + "]";
            this.cleanupLocalNodeRecoveryDescriptor(key);
            ses.addMeta(CHANNEL_FUT_META, chFut);
            ses.send(initMsg).listen(f -> {
                if (f.error() != null) {
                    GridFutureAdapter rq = (GridFutureAdapter)ses.meta(CHANNEL_FUT_META);
                    assert (rq != null);
                    rq.onDone(f.error());
                    ses.close();
                    return;
                }
                Runnable closeRun = () -> {
                    GridFutureAdapter rq = (GridFutureAdapter)ses.meta(CHANNEL_FUT_META);
                    assert (rq != null);
                    if (rq.onDone(CommunicationTcpUtils.handshakeTimeoutException())) {
                        ses.close();
                    }
                };
                this.handshakeTimeoutExecutorService.schedule(closeRun, this.cfg.connectionTimeout(), TimeUnit.MILLISECONDS);
            });
            GridFutureAdapter<Channel> gridFutureAdapter = chFut;
            return gridFutureAdapter;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException("Unable to create new channel connection to the remote node: " + remote, e);
        }
        finally {
            this.connectGate.leave();
        }
    }

    static boolean isChannelConnIdx(int connIdx) {
        return connIdx > 1024;
    }

    private void cleanupLocalNodeRecoveryDescriptor(ConnectionKey key) {
        if (CommunicationTcpUtils.usePairedConnections(this.locNodeSupplier.get(), this.attrs.pairedConnection())) {
            this.inRecDescs.remove(key);
            this.outRecDescs.remove(key);
        } else {
            this.recoveryDescs.remove(key);
        }
    }

    private void notifyChannelEvtListener(UUID nodeId, Channel channel, Message initMsg) {
        CommunicationListener<Message> lsnr0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Notify appropriate listeners due to a new channel opened: " + channel);
        }
        if ((lsnr0 = this.lsnr) instanceof CommunicationListenerEx) {
            ((CommunicationListenerEx)lsnr0).onChannelOpened(nodeId, initMsg, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long safeTcpHandshake(SocketChannel ch, UUID rmtNodeId, long timeout, GridSslMeta sslMeta, HandshakeMessage msg) throws IgniteCheckedException {
        HandshakeTimeoutObject timeoutObj = new HandshakeTimeoutObject(ch);
        this.handshakeTimeoutExecutorService.schedule(timeoutObj, timeout, TimeUnit.MILLISECONDS);
        try {
            long l = this.tcpHandshakeExecutor.tcpHandshake(ch, rmtNodeId, sslMeta, msg);
            return l;
        }
        finally {
            if (!timeoutObj.cancel()) {
                throw CommunicationTcpUtils.handshakeTimeoutException();
            }
        }
    }

    private boolean isLocalNodeAddress(InetSocketAddress addr) {
        return addr.getPort() == this.cfg.boundTcpPort() && (this.cfg.localHost().equals(addr.getAddress()) || addr.getAddress().isAnyLocalAddress() || this.cfg.localHost().isAnyLocalAddress() && U.isLocalAddress(addr.getAddress()));
    }

    private void checkClientQueueSize(GridNioSession ses, int msgQueueSize) {
        ClusterNode node;
        ConnectionKey id;
        if (this.cfg.slowClientQueueLimit() > 0 && msgQueueSize > this.cfg.slowClientQueueLimit() && (id = (ConnectionKey)ses.meta(TcpCommunicationSpi.CONN_IDX_META)) != null && (node = this.stateProvider.getSpiContext().node(id.nodeId())) != null && node.isClient()) {
            String msg = "Client node outbound message queue size exceeded slowClientQueueLimit, the client will be dropped (consider changing 'slowClientQueueLimit' configuration property) [srvNode=" + this.stateProvider.getSpiContext().localNode().id() + ", clientNode=" + node + ", slowClientQueueLimit=" + this.cfg.slowClientQueueLimit() + "]";
            U.quietAndWarn(this.log, msg);
            this.stateProvider.getSpiContext().failNode(id.nodeId(), msg);
        }
    }

    public void communicationWorker(CommunicationWorker commWorker) {
        this.commWorker = commWorker;
    }

    public void clientPool(ConnectionClientPool pool) {
    }

    public void socketChannelFactory(ThrowableSupplier<SocketChannel, IOException> sockChFactory) {
        this.socketChannelFactory = sockChFactory;
    }

    private boolean forceClientToServerConnections(ClusterNode node) {
        Boolean forceClientToSrvConnections = (Boolean)node.attribute(this.attrs.getForceClientServerConnections());
        return Boolean.TRUE.equals(forceClientToSrvConnections);
    }
}

