/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.storage.AlterColumnEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class AlterColumnEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class AlterColumnEntrySerializerV2
    implements CatalogObjectSerializer<AlterColumnEntry> {
        AlterColumnEntrySerializerV2() {
        }

        @Override
        public AlterColumnEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableColumnDescriptor descriptor = input.readEntry(CatalogTableColumnDescriptor.class);
            int tableId = input.readVarIntAsInt();
            return new AlterColumnEntry(tableId, descriptor);
        }

        @Override
        public void writeTo(AlterColumnEntry value, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(value.descriptor());
            output.writeVarInt(value.tableId());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class AlterColumnEntrySerializerV1
    implements CatalogObjectSerializer<AlterColumnEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public AlterColumnEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public AlterColumnEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE_COLUMN.id());
            CatalogTableColumnDescriptor descriptor = (CatalogTableColumnDescriptor)serializer.readFrom(input);
            int tableId = input.readVarIntAsInt();
            return new AlterColumnEntry(tableId, descriptor);
        }

        @Override
        public void writeTo(AlterColumnEntry value, CatalogObjectDataOutput output) throws IOException {
            this.serializers.get(1, value.descriptor().typeId()).writeTo(value.descriptor(), output);
            output.writeVarInt(value.tableId());
        }
    }
}

