/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.connect;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.EmptyCallInput;
import org.apache.ignite3.internal.cli.core.repl.Session;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.core.style.component.MessageUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElements;
import org.apache.ignite3.internal.cli.event.EventPublisher;
import org.apache.ignite3.internal.cli.event.Events;

@Singleton
public class DisconnectCall
implements Call<EmptyCallInput, String> {
    private final Session session;
    private final EventPublisher eventPublisher;
    private final ApiClientFactory clientFactory;

    public DisconnectCall(Session session, EventPublisher eventPublisher, ApiClientFactory clientFactory) {
        this.session = session;
        this.eventPublisher = eventPublisher;
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<String> execute(EmptyCallInput input) {
        SessionInfo sessionInfo = this.session.info();
        if (sessionInfo != null) {
            String nodeUrl = sessionInfo.nodeUrl();
            this.clientFactory.setSessionSettings(null);
            this.eventPublisher.publish(Events.disconnect());
            return DefaultCallOutput.success(MessageUiComponent.fromMessage("Disconnected from %s", UiElements.url(nodeUrl)).render());
        }
        return DefaultCallOutput.empty();
    }
}

