/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ignite3.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite3.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite3.internal.configuration.tree.InnerNode;
import org.apache.ignite3.internal.configuration.tree.NamedListNode;
import org.apache.ignite3.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite3.internal.util.ArrayUtils;

public abstract class KeysTrackingConfigurationVisitor<T>
implements ConfigurationVisitor<T> {
    private final StringBuilder currentKey = new StringBuilder();
    private final List<String> currentPath = new ArrayList<String>();

    private static boolean isDeprecated(Field field) {
        return field != null && field.getAnnotation(Deprecated.class) != null;
    }

    private static String[] getLegacyNames(Field field) {
        return field == null ? ArrayUtils.STRING_EMPTY_ARRAY : ConfigurationAsmGenerator.legacyNames(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T visitLeafNode(Field field, String key, Serializable val) {
        for (String legacyKey : KeysTrackingConfigurationVisitor.getLegacyNames(field)) {
            int prevPos = this.startVisit(field, legacyKey, false, true);
            try {
                this.doVisitLegacyLeafNode(field, legacyKey, val, false);
            }
            finally {
                this.endVisit(prevPos);
            }
        }
        int prevPos = this.startVisit(field, key, false, true);
        try {
            T t = KeysTrackingConfigurationVisitor.isDeprecated(field) ? this.doVisitLegacyLeafNode(field, key, val, true) : this.doVisitLeafNode(field, key, val);
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T visitInnerNode(Field field, String key, InnerNode node) {
        for (String legacyKey : KeysTrackingConfigurationVisitor.getLegacyNames(field)) {
            int prevPos = this.startVisit(field, legacyKey, false, false);
            try {
                this.doVisitLegacyInnerNode(field, legacyKey, node, false);
            }
            finally {
                this.endVisit(prevPos);
            }
        }
        int prevPos = this.startVisit(field, key, false, false);
        try {
            T t = KeysTrackingConfigurationVisitor.isDeprecated(field) ? this.doVisitLegacyInnerNode(field, key, node, true) : this.doVisitInnerNode(field, key, node);
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T visitNamedListNode(Field field, String key, NamedListNode<?> node) {
        for (String legacyKey : KeysTrackingConfigurationVisitor.getLegacyNames(field)) {
            int prevPos = this.startVisit(field, legacyKey, false, false);
            try {
                this.doVisitLegacyNamedListNode(field, legacyKey, node, false);
            }
            finally {
                this.endVisit(prevPos);
            }
        }
        int prevPos = this.startVisit(field, key, false, false);
        try {
            T t = KeysTrackingConfigurationVisitor.isDeprecated(field) ? this.doVisitLegacyNamedListNode(field, key, node, true) : this.doVisitNamedListNode(field, key, node);
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    protected T doVisitLeafNode(Field field, String key, Serializable val) {
        return null;
    }

    protected T doVisitLegacyLeafNode(Field field, String key, Serializable val, boolean isDeprecated) {
        return null;
    }

    protected T doVisitInnerNode(Field field, String key, InnerNode node) {
        node.traverseChildren(this, true);
        return null;
    }

    protected T doVisitLegacyInnerNode(Field field, String key, InnerNode node, boolean isDeprecated) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T doVisitNamedListNode(Field field, String key, NamedListNode<?> node) {
        for (String namedListKey : node.namedListKeys()) {
            int prevPos = this.startVisit(field, namedListKey, true, false);
            try {
                this.doVisitInnerNode(field, namedListKey, node.getInnerNode(namedListKey));
            }
            finally {
                this.endVisit(prevPos);
            }
        }
        return null;
    }

    protected T doVisitLegacyNamedListNode(Field field, String key, NamedListNode<?> node, boolean isDeprecated) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final T withTracking(Field field, String key, boolean escape, boolean leaf, Supplier<T> closure) {
        int prevPos = this.startVisit(field, key, escape, leaf);
        try {
            T t = closure.get();
            return t;
        }
        finally {
            this.endVisit(prevPos);
        }
    }

    protected final String currentKey() {
        return this.currentKey.toString();
    }

    protected final List<String> currentPath() {
        return Collections.unmodifiableList(this.currentPath);
    }

    private int startVisit(Field field, String key, boolean escape, boolean leaf) {
        int previousKeyLength = this.currentKey.length();
        this.currentKey.append(escape ? ConfigurationUtil.escape(key) : key);
        if (!leaf) {
            this.currentKey.append('.');
        }
        this.currentPath.add(key);
        return previousKeyLength;
    }

    private void endVisit(int previousKeyLength) {
        this.currentKey.setLength(previousKeyLength);
        this.currentPath.remove(this.currentPath.size() - 1);
    }
}

