/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ignite3.internal.deployunit.DeploymentUnitProcessor;
import org.apache.ignite3.internal.deployunit.FilesDeploymentUnit;
import org.apache.ignite3.internal.deployunit.StreamDeploymentUnit;
import org.apache.ignite3.internal.deployunit.ZipDeploymentUnit;
import org.apache.ignite3.internal.deployunit.tempstorage.TempStorage;
import org.apache.ignite3.internal.lang.RunnableX;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

class DeployerProcessor
implements DeploymentUnitProcessor<DeployArg, Boolean> {
    private static final IgniteLogger LOG = Loggers.forClass(DeployerProcessor.class);
    private final Executor executor;

    public DeployerProcessor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Boolean> processFilesContent(FilesDeploymentUnit unit, DeployArg deployArg) {
        return this.wrap(() -> {
            for (Map.Entry<String, Path> e : unit.content().entrySet()) {
                Files.move(e.getValue(), deployArg.unitFolder.resolve(e.getKey()), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> processStreamContent(StreamDeploymentUnit unit, DeployArg deployArg) {
        CompletableFuture[] array = (CompletableFuture[])unit.content().entrySet().stream().map(e -> deployArg.tempStorage.store((String)e.getKey(), (InputStream)e.getValue()).thenCompose(path -> this.doDeploy(deployArg.unitFolder, (String)e.getKey(), (Path)path))).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(array).handle((unused, throwable) -> throwable == null);
    }

    @Override
    public CompletableFuture<Boolean> processContentWithUnzip(ZipDeploymentUnit unit, DeployArg deployArg) {
        ZipInputStream zis = unit.zis();
        try {
            ZipEntry nextEntry = zis.getNextEntry();
            return this.processZipFile(nextEntry, zis, deployArg).handle((unused, throwable) -> throwable == null);
        }
        catch (IOException e) {
            return CompletableFutures.falseCompletedFuture();
        }
    }

    private CompletableFuture<Void> processZipFile(@Nullable ZipEntry ze, ZipInputStream zis, DeployArg deployArg) {
        if (ze == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        String entryName = ze.getName();
        if (ze.isDirectory()) {
            try {
                Path entryPath = deployArg.unitFolder.resolve(entryName);
                Files.createDirectories(entryPath, new FileAttribute[0]);
                return this.processZipFile(zis.getNextEntry(), zis, deployArg);
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        return ((CompletableFuture)deployArg.tempStorage.store(entryName, zis).thenCompose(path -> this.doDeploy(deployArg.unitFolder, entryName, (Path)path))).thenCompose(unused -> {
            try {
                return this.processZipFile(zis.getNextEntry(), zis, deployArg);
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
        });
    }

    private CompletableFuture<Boolean> wrap(RunnableX runnableX) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                runnableX.run();
                return true;
            }
            catch (Throwable t) {
                LOG.error("Failed to process deploy action.", t);
                return false;
            }
        }, this.executor);
    }

    private CompletableFuture<Boolean> doDeploy(Path unitFolder, String entryName, Path deployment) {
        return this.wrap(() -> {
            Path unitPath = unitFolder.resolve(entryName);
            Files.createDirectories(unitPath.getParent(), new FileAttribute[0]);
            Files.move(deployment, unitPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        });
    }

    static class DeployArg {
        private final Path unitFolder;
        private final TempStorage tempStorage;

        DeployArg(Path unitFolder, TempStorage tempStorage) {
            this.unitFolder = unitFolder;
            this.tempStorage = tempStorage;
        }
    }
}

