/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.util;

import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.jetbrains.annotations.Nullable;

public interface PageHandler<X, R> {
    public static final PageHandler<Void, Boolean> NO_OP;

    public R run(int var1, long var2, long var4, long var6, PageIo var8, X var9, int var10) throws IgniteInternalCheckedException;

    default public boolean releaseAfterWrite(int groupId, long pageId, long page, long pageAddr, X arg, int intArg) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R readPage(PageMemory pageMem, int groupId, long pageId, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteInternalCheckedException {
        long page = pageMem.acquirePage(groupId, pageId);
        try {
            R r = PageHandler.readPage(pageMem, groupId, pageId, page, h, arg, intArg, lockFailed);
            return r;
        }
        finally {
            pageMem.releasePage(groupId, pageId, page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R readPage(PageMemory pageMem, int groupId, long pageId, long page, PageHandler<X, R> h, X arg, int intArg, R lockFailed) throws IgniteInternalCheckedException {
        long pageAddr = 0L;
        try {
            pageAddr = pageMem.readLock(groupId, pageId, page);
            if (pageAddr == 0L) {
                R r = lockFailed;
                return r;
            }
            Object io = pageMem.ioRegistry().resolve(pageAddr);
            R r = h.run(groupId, pageId, page, pageAddr, (PageIo)io, arg, intArg);
            return r;
        }
        finally {
            if (pageAddr != 0L) {
                pageMem.readUnlock(groupId, pageId, page);
            }
        }
    }

    public static void initPage(PageMemory pageMem, int groupId, long pageId, PageIo init) throws IgniteInternalCheckedException {
        Boolean res = PageHandler.writePage(pageMem, groupId, pageId, NO_OP, init, null, 0, Boolean.FALSE);
        if (!1.$assertionsDisabled && res == Boolean.FALSE) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R writePage(PageMemory pageMem, int groupId, long pageId, PageHandler<X, R> h, @Nullable PageIo init, X arg, int intArg, R lockFailed) throws IgniteInternalCheckedException {
        boolean releaseAfterWrite = true;
        long page = pageMem.acquirePage(groupId, pageId);
        try {
            R r;
            long pageAddr = pageMem.writeLock(groupId, pageId, page);
            if (pageAddr == 0L) {
                R r2 = lockFailed;
                return r2;
            }
            boolean ok = false;
            try {
                if (init != null) {
                    PageHandler.doInitPage(pageMem, groupId, pageId, pageAddr, init);
                } else {
                    init = pageMem.ioRegistry().resolve(pageAddr);
                }
                R res = h.run(groupId, pageId, page, pageAddr, init, arg, intArg);
                ok = true;
                r = res;
            }
            catch (Throwable throwable) {
                if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
                    throw new AssertionError();
                }
                releaseAfterWrite = h.releaseAfterWrite(groupId, pageId, page, pageAddr, arg, intArg);
                if (releaseAfterWrite) {
                    pageMem.writeUnlock(groupId, pageId, page, ok);
                }
                throw throwable;
            }
            if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
                throw new AssertionError();
            }
            releaseAfterWrite = h.releaseAfterWrite(groupId, pageId, page, pageAddr, arg, intArg);
            if (releaseAfterWrite) {
                pageMem.writeUnlock(groupId, pageId, page, ok);
            }
            return r;
        }
        finally {
            if (releaseAfterWrite) {
                pageMem.releasePage(groupId, pageId, page);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X, R> R writePage(PageMemory pageMem, int groupId, long pageId, long page, PageHandler<X, R> h, PageIo init, X arg, int intArg, R lockFailed) throws IgniteInternalCheckedException {
        long pageAddr = pageMem.writeLock(groupId, pageId, page);
        if (pageAddr == 0L) {
            return lockFailed;
        }
        boolean ok = false;
        try {
            if (init != null) {
                PageHandler.doInitPage(pageMem, groupId, pageId, pageAddr, init);
            } else {
                init = pageMem.ioRegistry().resolve(pageAddr);
            }
            R res = h.run(groupId, pageId, page, pageAddr, init, arg, intArg);
            ok = true;
            R r = res;
            return r;
        }
        finally {
            if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
                throw new AssertionError();
            }
            if (h.releaseAfterWrite(groupId, pageId, page, pageAddr, arg, intArg)) {
                pageMem.writeUnlock(groupId, pageId, page, ok);
            }
        }
    }

    private static void doInitPage(PageMemory pageMem, int groupId, long pageId, long pageAddr, PageIo init) {
        if (!1.$assertionsDisabled && PageIo.getCrc(pageAddr) != 0) {
            throw new AssertionError();
        }
        init.initNewPage(pageAddr, pageId, pageMem.realPageSize(groupId));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        NO_OP = (groupId, pageId, page, pageAddr, io, arg, intArg) -> Boolean.TRUE;
    }
}

