/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.cluster;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite3.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.rest.ResourceHolder;
import org.apache.ignite3.internal.rest.api.cluster.ClusterNode;
import org.apache.ignite3.internal.rest.api.cluster.TopologyApi;
import org.apache.ignite3.network.NetworkAddress;
import org.apache.ignite3.network.NodeMetadata;

@Controller(value="/management/v1/cluster/topology")
public class TopologyController
implements TopologyApi,
ResourceHolder {
    private TopologyService topologyService;
    private ClusterManagementGroupManager cmgManager;

    public TopologyController(TopologyService topologyService, ClusterManagementGroupManager cmgManager) {
        this.topologyService = topologyService;
        this.cmgManager = cmgManager;
    }

    @Override
    public Collection<ClusterNode> physicalTopology() {
        return TopologyController.toClusterNodeDtos(this.topologyService.allMembers());
    }

    @Override
    public CompletableFuture<Collection<ClusterNode>> logicalTopology() {
        return ((CompletableFuture)((CompletableFuture)this.cmgManager.clusterState().thenCompose(state -> this.cmgManager.logicalTopology())).thenApply(LogicalTopologySnapshot::nodes)).thenApply(TopologyController::toClusterNodeDtosFromLogicalNodes);
    }

    private static List<ClusterNode> toClusterNodeDtos(Collection<InternalClusterNode> nodes) {
        return nodes.stream().map(TopologyController::toClusterNodeDto).collect(Collectors.toList());
    }

    private static List<ClusterNode> toClusterNodeDtosFromLogicalNodes(Collection<LogicalNode> nodes) {
        return nodes.stream().map(TopologyController::toClusterNodeDto).collect(Collectors.toList());
    }

    private static ClusterNode toClusterNodeDto(InternalClusterNode node) {
        NetworkAddress addr = node.address();
        org.apache.ignite3.internal.rest.api.cluster.NetworkAddress addrDto = new org.apache.ignite3.internal.rest.api.cluster.NetworkAddress(addr.host(), addr.port());
        return new ClusterNode(node.id(), node.name(), addrDto, TopologyController.toNodeMetadataDto(node.nodeMetadata()));
    }

    private static org.apache.ignite3.internal.rest.api.cluster.NodeMetadata toNodeMetadataDto(NodeMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        return new org.apache.ignite3.internal.rest.api.cluster.NodeMetadata(metadata.restHost(), metadata.httpPort(), metadata.httpsPort());
    }

    @Override
    public void cleanResources() {
        this.topologyService = null;
        this.cmgManager = null;
    }
}

