/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.security.authentication.basic;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.security.authentication.AuthenticationRequest;
import org.apache.ignite3.internal.security.authentication.Authenticator;
import org.apache.ignite3.internal.security.authentication.UserDetails;
import org.apache.ignite3.internal.security.authentication.UsernamePasswordRequest;
import org.apache.ignite3.internal.security.authentication.basic.BasicUser;
import org.apache.ignite3.security.exception.InvalidCredentialsException;
import org.apache.ignite3.security.exception.UnsupportedAuthenticationTypeException;

public class BasicAuthenticator
implements Authenticator {
    private final String providerName;
    private final Map<String, BasicUser> users;

    public BasicAuthenticator(String providerName, List<BasicUser> users) {
        this.providerName = providerName;
        this.users = users.stream().collect(Collectors.toMap(user -> user.name().toLowerCase(Locale.US), Function.identity()));
    }

    @Override
    public CompletableFuture<UserDetails> authenticateAsync(AuthenticationRequest<?, ?> authenticationRequest) {
        if (!(authenticationRequest instanceof UsernamePasswordRequest)) {
            return CompletableFuture.failedFuture(new UnsupportedAuthenticationTypeException("Unsupported authentication type: " + authenticationRequest.getClass().getName()));
        }
        String requestUsername = (String)authenticationRequest.getIdentity();
        String requestPassword = (String)authenticationRequest.getSecret();
        BasicUser basicUser = this.users.get(requestUsername.toLowerCase());
        if (basicUser != null && basicUser.password().equals(requestPassword)) {
            return CompletableFuture.completedFuture(new UserDetails(basicUser.name(), this.providerName));
        }
        return CompletableFuture.failedFuture(new InvalidCredentialsException("Invalid credentials"));
    }
}

