/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.sql.engine.AsyncSqlCursor;
import org.apache.ignite3.internal.sql.engine.SqlQueryType;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.prepare.partitionawareness.PartitionAwarenessMetadata;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.jetbrains.annotations.Nullable;

public class AsyncSqlCursorImpl<T>
implements AsyncSqlCursor<T> {
    private final SqlQueryType queryType;
    private final ResultSetMetadata meta;
    private final AsyncDataCursor<T> dataCursor;
    @Nullable
    private final PartitionAwarenessMetadata partitionAwarenessMetadata;
    @Nullable
    private final CompletableFuture<AsyncSqlCursor<T>> nextStatement;

    public AsyncSqlCursorImpl(SqlQueryType queryType, ResultSetMetadata meta, @Nullable PartitionAwarenessMetadata partitionAwarenessMetadata, AsyncDataCursor<T> dataCursor, @Nullable CompletableFuture<AsyncSqlCursor<T>> nextStatement) {
        this.queryType = queryType;
        this.meta = meta;
        this.partitionAwarenessMetadata = partitionAwarenessMetadata;
        this.dataCursor = dataCursor;
        this.nextStatement = nextStatement;
    }

    public AsyncSqlCursorImpl(SqlQueryType queryType, ResultSetMetadata meta, AsyncDataCursor<T> dataCursor, @Nullable CompletableFuture<AsyncSqlCursor<T>> nextStatement) {
        this(queryType, meta, null, dataCursor, nextStatement);
    }

    @Override
    public SqlQueryType queryType() {
        return this.queryType;
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.meta;
    }

    @Override
    @Nullable
    public PartitionAwarenessMetadata partitionAwarenessMetadata() {
        return this.partitionAwarenessMetadata;
    }

    @Override
    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        return this.dataCursor.requestNextAsync(rows);
    }

    @Override
    public boolean hasNextResult() {
        return this.nextStatement != null;
    }

    @Override
    public CompletableFuture<AsyncSqlCursor<T>> nextResult() {
        if (this.nextStatement == null) {
            throw new NoSuchElementException("Query has no more results");
        }
        return this.nextStatement;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.dataCursor.closeAsync();
    }

    @Override
    public CompletableFuture<Void> cancelAsync(AsyncDataCursor.CancellationReason reason) {
        return this.dataCursor.cancelAsync(reason);
    }

    @Override
    public CompletableFuture<Void> onClose() {
        return this.dataCursor.onClose();
    }

    @Override
    public CompletableFuture<Void> onFirstPageReady() {
        return this.dataCursor.onFirstPageReady();
    }
}

