/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.util.Cancellable;

public class QueryCancel {
    private final CompletableFuture<Reason> state = new CompletableFuture();

    public void add(Cancellable clo) throws QueryCancelledException {
        assert (clo != null);
        this.state.thenAccept(reason -> clo.cancel(reason == Reason.TIMEOUT));
        this.throwIfCancelled();
    }

    public void attach(QueryCancel another) throws QueryCancelledException {
        this.state.thenAccept(another.state::complete);
        this.throwIfCancelled();
    }

    public void setTimeout(ScheduledExecutorService scheduler, long timeoutMillis) {
        scheduler.schedule(() -> this.state.complete(Reason.TIMEOUT), timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void cancel() {
        this.state.complete(Reason.CANCEL);
    }

    public boolean isCancelled() {
        return this.state.isDone();
    }

    public void throwIfCancelled() throws QueryCancelledException {
        if (!this.state.isDone()) {
            return;
        }
        Reason reason = this.state.join();
        throw new QueryCancelledException(reason == Reason.TIMEOUT ? "Query timeout" : "The query was cancelled while executing.");
    }

    static enum Reason {
        CANCEL,
        TIMEOUT;

    }
}

