/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.mapping;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.ignite3.internal.sql.engine.exec.mapping.IdGenerator;
import org.apache.ignite3.internal.sql.engine.prepare.Fragment;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteRelShuttle;
import org.apache.ignite3.internal.sql.engine.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite3.internal.sql.engine.rel.IgniteExchange;
import org.apache.ignite3.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteReceiver;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSender;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableFunctionScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableModify;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTrimExchange;
import org.apache.ignite3.internal.sql.engine.rel.SourceAwareIgniteRel;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.Cloner;
import org.apache.ignite3.internal.sql.engine.util.Commons;

public class QuerySplitter
extends IgniteRelShuttle {
    private final Deque<FragmentProto> stack = new LinkedList<FragmentProto>();
    private final RelOptCluster cluster;
    private final IdGenerator idGenerator;
    private FragmentProto curr;
    private boolean correlated = false;

    public QuerySplitter(IdGenerator idGenerator, RelOptCluster cluster) {
        this.idGenerator = idGenerator;
        this.cluster = cluster;
    }

    public List<Fragment> split(IgniteRel root) {
        ArrayList<Fragment> res = new ArrayList<Fragment>();
        this.stack.push(new FragmentProto(this.idGenerator.nextId(), false, root));
        while (!this.stack.isEmpty()) {
            this.curr = this.stack.pop();
            this.curr.root = Cloner.clone(this.curr.root, this.cluster);
            this.correlated = this.curr.correlated;
            this.curr.root = this.visit(this.curr.root);
            res.add(this.curr.build());
        }
        return res;
    }

    @Override
    public IgniteRel visit(IgniteReceiver rel) {
        throw new AssertionError();
    }

    @Override
    public IgniteRel visit(IgniteCorrelatedNestedLoopJoin rel) {
        List inputs = Commons.cast(rel.getInputs());
        assert (inputs.size() == 2);
        this.visitChild(rel, 0, (IgniteRel)inputs.get(0));
        boolean correlatedBefore = this.correlated;
        this.correlated = true;
        this.visitChild(rel, 1, (IgniteRel)inputs.get(1));
        this.correlated = correlatedBefore;
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteExchange rel) {
        long sourceFragmentId;
        RelOptCluster cluster = rel.getCluster();
        long targetFragmentId = this.curr.id;
        long exchangeId = sourceFragmentId = this.idGenerator.nextId();
        IgniteReceiver receiver = new IgniteReceiver(cluster, rel.getTraitSet(), rel.getRowType(), exchangeId, sourceFragmentId);
        IgniteSender sender = new IgniteSender(cluster, rel.getTraitSet(), rel.getInput(), exchangeId, targetFragmentId, rel.distribution());
        this.curr.remotes.add(receiver);
        this.stack.push(new FragmentProto(sourceFragmentId, this.correlated, sender));
        return receiver;
    }

    @Override
    public IgniteRel visit(IgniteTrimExchange rel) {
        return ((SourceAwareIgniteRel)this.processNode(rel)).clone(rel.sourceId());
    }

    @Override
    public IgniteRel visit(IgniteIndexScan rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        long sourceId = rel.sourceId();
        this.curr.tables.put(sourceId, (Object)table);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteTableScan rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        long sourceId = rel.sourceId();
        this.curr.tables.put(sourceId, (Object)table);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteTableFunctionScan rel) {
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteTableModify rel) {
        IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        assert (table != null);
        long sourceId = rel.sourceId();
        this.curr.tables.put(sourceId, (Object)table);
        IgniteRel cloned = rel.clone(sourceId);
        IgniteRel input = this.visit((IgniteRel)rel.getInput(0));
        cloned.replaceInput(0, (RelNode)input);
        return cloned;
    }

    @Override
    public IgniteRel visit(IgniteSystemViewScan rel) {
        IgniteSystemView view = (IgniteSystemView)rel.getTable().unwrap(IgniteSystemView.class);
        assert (view != null);
        if (this.curr.seenRelations.add(view.id())) {
            this.curr.systemViews.add(view);
        }
        return rel;
    }

    private static class FragmentProto {
        private final long id;
        private final boolean correlated;
        private IgniteRel root;
        private final IntSet seenRelations = new IntOpenHashSet();
        private final List<IgniteReceiver> remotes = new ArrayList<IgniteReceiver>();
        private final Long2ObjectMap<IgniteTable> tables = new Long2ObjectOpenHashMap();
        private final List<IgniteSystemView> systemViews = new ArrayList<IgniteSystemView>();

        private FragmentProto(long id, boolean correlated, IgniteRel root) {
            this.id = id;
            this.correlated = correlated;
            this.root = root;
        }

        Fragment build() {
            return new Fragment(this.id, this.correlated, this.root, this.remotes, this.tables, this.systemViews);
        }
    }
}

