/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.UUID;
import org.apache.ignite3.internal.lang.InternalTuple;

abstract class AbstractProjectedTuple
implements InternalTuple {
    protected InternalTuple delegate;
    protected int[] projection;
    private boolean normalized = false;

    AbstractProjectedTuple(InternalTuple delegate, int[] projection) {
        this.delegate = delegate;
        this.projection = projection;
    }

    @Override
    public int elementCount() {
        return this.projection.length;
    }

    @Override
    public boolean hasNullValue(int col) {
        return this.delegate.hasNullValue(this.projection[col]);
    }

    @Override
    public boolean booleanValue(int col) {
        return this.delegate.booleanValue(this.projection[col]);
    }

    @Override
    public Boolean booleanValueBoxed(int col) {
        return this.delegate.booleanValueBoxed(this.projection[col]);
    }

    @Override
    public byte byteValue(int col) {
        return this.delegate.byteValue(this.projection[col]);
    }

    @Override
    public Byte byteValueBoxed(int col) {
        return this.delegate.byteValueBoxed(this.projection[col]);
    }

    @Override
    public short shortValue(int col) {
        return this.delegate.shortValue(this.projection[col]);
    }

    @Override
    public Short shortValueBoxed(int col) {
        return this.delegate.shortValueBoxed(this.projection[col]);
    }

    @Override
    public int intValue(int col) {
        return this.delegate.intValue(this.projection[col]);
    }

    @Override
    public Integer intValueBoxed(int col) {
        return this.delegate.intValueBoxed(this.projection[col]);
    }

    @Override
    public long longValue(int col) {
        return this.delegate.longValue(this.projection[col]);
    }

    @Override
    public Long longValueBoxed(int col) {
        return this.delegate.longValueBoxed(this.projection[col]);
    }

    @Override
    public float floatValue(int col) {
        return this.delegate.floatValue(this.projection[col]);
    }

    @Override
    public Float floatValueBoxed(int col) {
        return this.delegate.floatValueBoxed(this.projection[col]);
    }

    @Override
    public double doubleValue(int col) {
        return this.delegate.doubleValue(this.projection[col]);
    }

    @Override
    public Double doubleValueBoxed(int col) {
        return this.delegate.doubleValueBoxed(this.projection[col]);
    }

    @Override
    public BigDecimal decimalValue(int col, int decimalScale) {
        return this.delegate.decimalValue(this.projection[col], decimalScale);
    }

    @Override
    public String stringValue(int col) {
        return this.delegate.stringValue(this.projection[col]);
    }

    @Override
    public byte[] bytesValue(int col) {
        return this.delegate.bytesValue(this.projection[col]);
    }

    @Override
    public UUID uuidValue(int col) {
        return this.delegate.uuidValue(this.projection[col]);
    }

    @Override
    public LocalDate dateValue(int col) {
        return this.delegate.dateValue(this.projection[col]);
    }

    @Override
    public LocalTime timeValue(int col) {
        return this.delegate.timeValue(this.projection[col]);
    }

    @Override
    public LocalDateTime dateTimeValue(int col) {
        return this.delegate.dateTimeValue(this.projection[col]);
    }

    @Override
    public Instant timestampValue(int col) {
        return this.delegate.timestampValue(this.projection[col]);
    }

    @Override
    public Period periodValue(int col) {
        return this.delegate.periodValue(this.projection[col]);
    }

    @Override
    public Duration durationValue(int col) {
        return this.delegate.durationValue(this.projection[col]);
    }

    @Override
    public ByteBuffer byteBuffer() {
        this.normalizeIfNeeded();
        return this.delegate.byteBuffer();
    }

    protected abstract void normalize();

    private void normalizeIfNeeded() {
        if (this.normalized) {
            return;
        }
        this.normalize();
        this.normalized = true;
    }
}

