/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.partition;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.Partition;
import org.apache.ignite3.table.partition.PartitionManager;

public class PublicApiThreadingPartitionManager
implements PartitionManager {
    private final PartitionManager partitionManager;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingPartitionManager(PartitionManager partitionManager, Executor asyncContinuationExecutor) {
        this.partitionManager = partitionManager;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.preventThreadHijack(this.partitionManager.primaryReplicaAsync(partition));
    }

    @Override
    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        return this.preventThreadHijack(this.partitionManager.primaryReplicasAsync());
    }

    @Override
    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        return this.preventThreadHijack(this.partitionManager.partitionAsync(key, mapper));
    }

    @Override
    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        return this.preventThreadHijack(this.partitionManager.partitionAsync(key));
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, this.asyncContinuationExecutor);
    }
}

