/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl.cli;

import java.util.concurrent.Executor;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.Status;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class TransferLeaderRequestProcessor
extends BaseCliRequestProcessor<CliRequests.TransferLeaderRequest> {
    public TransferLeaderRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.TransferLeaderRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.TransferLeaderRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.TransferLeaderRequest request, IgniteCliRpcRequestClosure done) {
        PeerId peer = new PeerId();
        if (request.peerId() != null && !peer.parse(request.peerId())) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", request.peerId());
        }
        LOG.info("Receive TransferLeaderRequest to {} from {}, newLeader will be {}.", ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), peer);
        Status st = ctx.node.transferLeadershipTo(peer);
        return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), st);
    }

    @Override
    public String interest() {
        return CliRequests.TransferLeaderRequest.class.getName();
    }
}

