/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import org.apache.ignite3.raft.jraft.util.Requires;

public final class Ints {
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    public static int checkedCast(long value) {
        int result = (int)value;
        Requires.requireTrue((long)result == value, "out of range: " + value);
        return result;
    }

    public static int saturatedCast(long value) {
        return value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (value < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value);
    }

    public static int findNextPositivePowerOfTwo(int value) {
        return value <= 0 ? 1 : (value >= 0x40000000 ? 0x40000000 : 1 << 32 - Integer.numberOfLeadingZeros(value - 1));
    }

    public static int roundToPowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static boolean isPowerOfTwo(int value) {
        return (value & value - 1) == 0;
    }

    private Ints() {
    }
}

