/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.invoker.ApiResponse;
import org.apache.ignite3.rest.client.invoker.Configuration;
import org.apache.ignite3.rest.client.invoker.Pair;
import org.apache.ignite3.rest.client.model.DeployMode;
import org.apache.ignite3.rest.client.model.DeploymentStatus;
import org.apache.ignite3.rest.client.model.UnitStatus;

public class DeploymentApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DeploymentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeploymentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call deployUnitCall(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/units/{unitId}/{unitVersion}".replace("{unitId}", this.localVarApiClient.escapeString(unitId.toString())).replace("{unitVersion}", this.localVarApiClient.escapeString(unitVersion.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (unitContent != null) {
            localVarFormParams.put("unitContent", unitContent);
        }
        if (deployMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployMode", (Object)deployMode));
        }
        if (initialNodes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "initialNodes", initialNodes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deployUnitValidateBeforeCall(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes, ApiCallback _callback) throws ApiException {
        if (unitId == null) {
            throw new ApiException("Missing the required parameter 'unitId' when calling deployUnit(Async)");
        }
        if (unitVersion == null) {
            throw new ApiException("Missing the required parameter 'unitVersion' when calling deployUnit(Async)");
        }
        if (unitContent == null) {
            throw new ApiException("Missing the required parameter 'unitContent' when calling deployUnit(Async)");
        }
        return this.deployUnitCall(unitId, unitVersion, unitContent, deployMode, initialNodes, _callback);
    }

    public Boolean deployUnit(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes) throws ApiException {
        ApiResponse<Boolean> localVarResp = this.deployUnitWithHttpInfo(unitId, unitVersion, unitContent, deployMode, initialNodes);
        return localVarResp.getData();
    }

    public ApiResponse<Boolean> deployUnitWithHttpInfo(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes) throws ApiException {
        Call localVarCall = this.deployUnitValidateBeforeCall(unitId, unitVersion, unitContent, deployMode, initialNodes, null);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deployUnitAsync(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes, ApiCallback<Boolean> _callback) throws ApiException {
        Call localVarCall = this.deployUnitValidateBeforeCall(unitId, unitVersion, unitContent, deployMode, initialNodes, _callback);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deployZipUnitCall(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/units/zip/{unitId}/{unitVersion}".replace("{unitId}", this.localVarApiClient.escapeString(unitId.toString())).replace("{unitVersion}", this.localVarApiClient.escapeString(unitVersion.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (unitContent != null) {
            localVarFormParams.put("unitContent", unitContent);
        }
        if (deployMode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deployMode", (Object)deployMode));
        }
        if (initialNodes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "initialNodes", initialNodes));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deployZipUnitValidateBeforeCall(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes, ApiCallback _callback) throws ApiException {
        if (unitId == null) {
            throw new ApiException("Missing the required parameter 'unitId' when calling deployZipUnit(Async)");
        }
        if (unitVersion == null) {
            throw new ApiException("Missing the required parameter 'unitVersion' when calling deployZipUnit(Async)");
        }
        if (unitContent == null) {
            throw new ApiException("Missing the required parameter 'unitContent' when calling deployZipUnit(Async)");
        }
        return this.deployZipUnitCall(unitId, unitVersion, unitContent, deployMode, initialNodes, _callback);
    }

    public Boolean deployZipUnit(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes) throws ApiException {
        ApiResponse<Boolean> localVarResp = this.deployZipUnitWithHttpInfo(unitId, unitVersion, unitContent, deployMode, initialNodes);
        return localVarResp.getData();
    }

    public ApiResponse<Boolean> deployZipUnitWithHttpInfo(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes) throws ApiException {
        Call localVarCall = this.deployZipUnitValidateBeforeCall(unitId, unitVersion, unitContent, deployMode, initialNodes, null);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deployZipUnitAsync(String unitId, String unitVersion, List<File> unitContent, DeployMode deployMode, List<String> initialNodes, ApiCallback<Boolean> _callback) throws ApiException {
        Call localVarCall = this.deployZipUnitValidateBeforeCall(unitId, unitVersion, unitContent, deployMode, initialNodes, _callback);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterStatusesCall(List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/cluster/units";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (statuses != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "statuses", statuses));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterStatusesValidateBeforeCall(List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        return this.listClusterStatusesCall(statuses, _callback);
    }

    public List<UnitStatus> listClusterStatuses(List<DeploymentStatus> statuses) throws ApiException {
        ApiResponse<List<UnitStatus>> localVarResp = this.listClusterStatusesWithHttpInfo(statuses);
        return localVarResp.getData();
    }

    public ApiResponse<List<UnitStatus>> listClusterStatusesWithHttpInfo(List<DeploymentStatus> statuses) throws ApiException {
        Call localVarCall = this.listClusterStatusesValidateBeforeCall(statuses, null);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterStatusesAsync(List<DeploymentStatus> statuses, ApiCallback<List<UnitStatus>> _callback) throws ApiException {
        Call localVarCall = this.listClusterStatusesValidateBeforeCall(statuses, _callback);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterStatusesByUnitCall(String unitId, String version, List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/cluster/units/{unitId}".replace("{unitId}", this.localVarApiClient.escapeString(unitId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (statuses != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "statuses", statuses));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterStatusesByUnitValidateBeforeCall(String unitId, String version, List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        if (unitId == null) {
            throw new ApiException("Missing the required parameter 'unitId' when calling listClusterStatusesByUnit(Async)");
        }
        return this.listClusterStatusesByUnitCall(unitId, version, statuses, _callback);
    }

    public List<UnitStatus> listClusterStatusesByUnit(String unitId, String version, List<DeploymentStatus> statuses) throws ApiException {
        ApiResponse<List<UnitStatus>> localVarResp = this.listClusterStatusesByUnitWithHttpInfo(unitId, version, statuses);
        return localVarResp.getData();
    }

    public ApiResponse<List<UnitStatus>> listClusterStatusesByUnitWithHttpInfo(String unitId, String version, List<DeploymentStatus> statuses) throws ApiException {
        Call localVarCall = this.listClusterStatusesByUnitValidateBeforeCall(unitId, version, statuses, null);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterStatusesByUnitAsync(String unitId, String version, List<DeploymentStatus> statuses, ApiCallback<List<UnitStatus>> _callback) throws ApiException {
        Call localVarCall = this.listClusterStatusesByUnitValidateBeforeCall(unitId, version, statuses, _callback);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNodeStatusesCall(List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/node/units";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (statuses != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "statuses", statuses));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNodeStatusesValidateBeforeCall(List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        return this.listNodeStatusesCall(statuses, _callback);
    }

    public List<UnitStatus> listNodeStatuses(List<DeploymentStatus> statuses) throws ApiException {
        ApiResponse<List<UnitStatus>> localVarResp = this.listNodeStatusesWithHttpInfo(statuses);
        return localVarResp.getData();
    }

    public ApiResponse<List<UnitStatus>> listNodeStatusesWithHttpInfo(List<DeploymentStatus> statuses) throws ApiException {
        Call localVarCall = this.listNodeStatusesValidateBeforeCall(statuses, null);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNodeStatusesAsync(List<DeploymentStatus> statuses, ApiCallback<List<UnitStatus>> _callback) throws ApiException {
        Call localVarCall = this.listNodeStatusesValidateBeforeCall(statuses, _callback);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listNodeStatusesByUnitCall(String unitId, String version, List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/node/units/{unitId}".replace("{unitId}", this.localVarApiClient.escapeString(unitId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if (statuses != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "statuses", statuses));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listNodeStatusesByUnitValidateBeforeCall(String unitId, String version, List<DeploymentStatus> statuses, ApiCallback _callback) throws ApiException {
        if (unitId == null) {
            throw new ApiException("Missing the required parameter 'unitId' when calling listNodeStatusesByUnit(Async)");
        }
        return this.listNodeStatusesByUnitCall(unitId, version, statuses, _callback);
    }

    public List<UnitStatus> listNodeStatusesByUnit(String unitId, String version, List<DeploymentStatus> statuses) throws ApiException {
        ApiResponse<List<UnitStatus>> localVarResp = this.listNodeStatusesByUnitWithHttpInfo(unitId, version, statuses);
        return localVarResp.getData();
    }

    public ApiResponse<List<UnitStatus>> listNodeStatusesByUnitWithHttpInfo(String unitId, String version, List<DeploymentStatus> statuses) throws ApiException {
        Call localVarCall = this.listNodeStatusesByUnitValidateBeforeCall(unitId, version, statuses, null);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listNodeStatusesByUnitAsync(String unitId, String version, List<DeploymentStatus> statuses, ApiCallback<List<UnitStatus>> _callback) throws ApiException {
        Call localVarCall = this.listNodeStatusesByUnitValidateBeforeCall(unitId, version, statuses, _callback);
        Type localVarReturnType = new TypeToken<List<UnitStatus>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call undeployUnitCall(String unitId, String unitVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/deployment/units/{unitId}/{unitVersion}".replace("{unitId}", this.localVarApiClient.escapeString(unitId.toString())).replace("{unitVersion}", this.localVarApiClient.escapeString(unitVersion.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call undeployUnitValidateBeforeCall(String unitId, String unitVersion, ApiCallback _callback) throws ApiException {
        if (unitId == null) {
            throw new ApiException("Missing the required parameter 'unitId' when calling undeployUnit(Async)");
        }
        if (unitVersion == null) {
            throw new ApiException("Missing the required parameter 'unitVersion' when calling undeployUnit(Async)");
        }
        return this.undeployUnitCall(unitId, unitVersion, _callback);
    }

    public Boolean undeployUnit(String unitId, String unitVersion) throws ApiException {
        ApiResponse<Boolean> localVarResp = this.undeployUnitWithHttpInfo(unitId, unitVersion);
        return localVarResp.getData();
    }

    public ApiResponse<Boolean> undeployUnitWithHttpInfo(String unitId, String unitVersion) throws ApiException {
        Call localVarCall = this.undeployUnitValidateBeforeCall(unitId, unitVersion, null);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call undeployUnitAsync(String unitId, String unitVersion, ApiCallback<Boolean> _callback) throws ApiException {
        Call localVarCall = this.undeployUnitValidateBeforeCall(unitId, unitVersion, _callback);
        Type localVarReturnType = new TypeToken<Boolean>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

