/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.SetArchivingPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CancelArchivingOperator
extends Operator {
    private PartialPath storageGroup = null;
    private long taskId = -1L;

    public CancelArchivingOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.SET_ARCHIVING;
    }

    public PartialPath getStorageGroup() {
        return this.storageGroup;
    }

    public void setStorageGroup(PartialPath storageGroup) {
        this.storageGroup = storageGroup;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(long taskId) {
        this.taskId = taskId;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        if (this.storageGroup != null) {
            return new SetArchivingPlan(this.storageGroup);
        }
        if (this.taskId != -1L) {
            return new SetArchivingPlan(this.taskId);
        }
        return new SetArchivingPlan();
    }
}

