/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.reader;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.db.query.reader.universal.DescPriorityMergeReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class ManagedDescPriorityMergeReader
extends DescPriorityMergeReader
implements ManagedSeriesReader,
IPointReader {
    private static final int BATCH_SIZE = 4096;
    private volatile boolean managedByPool;
    private volatile boolean hasRemaining;
    private BatchData batchData;
    private TSDataType dataType;

    public ManagedDescPriorityMergeReader(TSDataType dataType) {
        this.dataType = dataType;
    }

    public boolean isManagedByQueryManager() {
        return this.managedByPool;
    }

    public void setManagedByQueryManager(boolean managedByQueryManager) {
        this.managedByPool = managedByQueryManager;
    }

    public boolean hasRemaining() {
        return this.hasRemaining;
    }

    public void setHasRemaining(boolean hasRemaining) {
        this.hasRemaining = hasRemaining;
    }

    public boolean hasNextBatch() throws IOException {
        if (this.batchData != null) {
            return true;
        }
        this.constructBatch();
        return this.batchData != null;
    }

    private void constructBatch() throws IOException {
        if (this.hasNextTimeValuePair()) {
            this.batchData = new BatchData(this.dataType);
            while (this.hasNextTimeValuePair() && this.batchData.length() < 4096) {
                TimeValuePair next = this.nextTimeValuePair();
                this.batchData.putAnObject(next.getTimestamp(), next.getValue().getValue());
            }
        }
    }

    public BatchData nextBatch() throws IOException {
        if (!this.hasNextBatch()) {
            throw new NoSuchElementException();
        }
        BatchData ret = this.batchData;
        this.batchData = null;
        return ret;
    }
}

