/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import java.util.Map;
import reactor.netty.tcp.SslProvider;

final class SniProvider {
    final Map<String, SslProvider> confPerDomainName;
    final SslProvider defaultSslProvider;

    void addSniHandler(Channel channel, boolean sslDebug) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("reactor.left.sslHandler", (ChannelHandler)this.newSniHandler());
        SslProvider.addSslReadHandler(pipeline, sslDebug);
    }

    SniProvider(Map<String, SslProvider> confPerDomainName, SslProvider defaultSslProvider) {
        this.confPerDomainName = confPerDomainName;
        this.defaultSslProvider = defaultSslProvider;
    }

    SniHandler newSniHandler() {
        DomainWildcardMappingBuilder mappingsContextBuilder = new DomainWildcardMappingBuilder((Object)this.defaultSslProvider.getSslContext());
        this.confPerDomainName.forEach((s, sslProvider) -> mappingsContextBuilder.add(s, (Object)sslProvider.getSslContext()));
        DomainWildcardMappingBuilder mappingsSslProviderBuilder = new DomainWildcardMappingBuilder((Object)this.defaultSslProvider);
        this.confPerDomainName.forEach((arg_0, arg_1) -> ((DomainWildcardMappingBuilder)mappingsSslProviderBuilder).add(arg_0, arg_1));
        return new AdvancedSniHandler((Mapping<? super String, ? extends SslProvider>)mappingsSslProviderBuilder.build(), this.defaultSslProvider, (Mapping<? super String, ? extends SslContext>)mappingsContextBuilder.build());
    }

    static final class AdvancedSniHandler
    extends SniHandler {
        final Mapping<? super String, ? extends SslProvider> confPerDomainName;
        final SslProvider defaultSslProvider;

        AdvancedSniHandler(Mapping<? super String, ? extends SslProvider> confPerDomainName, SslProvider defaultSslProvider, Mapping<? super String, ? extends SslContext> mappings) {
            super(mappings);
            this.confPerDomainName = confPerDomainName;
            this.defaultSslProvider = defaultSslProvider;
        }

        protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
            SslHandler sslHandler = super.newSslHandler(context, allocator);
            String hostName = this.hostname();
            if (hostName == null) {
                this.defaultSslProvider.configure(sslHandler);
            } else {
                ((SslProvider)this.confPerDomainName.map((Object)this.hostname())).configure(sslHandler);
            }
            return sslHandler;
        }
    }
}

