/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.manage;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.cluster.exception.EntryCompactedException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.LogApplier;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.log.manage.PartitionedSnapshotLogManager;
import org.apache.iotdb.cluster.log.snapshot.FileSnapshot;
import org.apache.iotdb.cluster.partition.PartitionTable;
import org.apache.iotdb.cluster.partition.slot.SlotPartitionTable;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePartitionedSnapshotLogManager
extends PartitionedSnapshotLogManager<FileSnapshot> {
    private static final Logger logger = LoggerFactory.getLogger(FilePartitionedSnapshotLogManager.class);

    public FilePartitionedSnapshotLogManager(LogApplier logApplier, PartitionTable partitionTable, Node header, Node thisNode, DataGroupMember dataGroupMember) {
        super(logApplier, partitionTable, header, thisNode, FileSnapshot.Factory.INSTANCE, dataGroupMember);
    }

    private void syncFlushAllProcessor(List<Integer> requiredSlots, boolean needLeader) {
        logger.info("{}: Start flush all storage group processor in one data group", (Object)this.getName());
        Map storageGroupPartitions = StorageEngine.getInstance().getWorkingStorageGroupPartitions();
        if (storageGroupPartitions.size() == 0) {
            logger.info("{}: no need to flush processor", (Object)this.getName());
            return;
        }
        this.dataGroupMember.flushFileWhenDoSnapshot(storageGroupPartitions, requiredSlots, needLeader);
    }

    @Override
    public void takeSnapshot() throws IOException {
        this.takeSnapshotForSpecificSlots(((SlotPartitionTable)this.partitionTable).getNodeSlots(this.dataGroupMember.getHeader()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeSnapshotForSpecificSlots(List<Integer> requiredSlots, boolean needLeader) throws IOException {
        try {
            logger.info("{}: Taking snapshots, flushing IoTDB", (Object)this.getName());
            this.setBlockAppliedCommitIndex(this.getCommitLogIndex());
            super.takeSnapshot();
            this.syncFlushAllProcessor(requiredSlots, needLeader);
            logger.info("{}: Taking snapshots, IoTDB is flushed", (Object)this.getName());
            FilePartitionedSnapshotLogManager filePartitionedSnapshotLogManager = this;
            synchronized (filePartitionedSnapshotLogManager) {
                this.collectTimeseriesSchemas(requiredSlots);
                this.snapshotLastLogIndex = this.getBlockAppliedCommitIndex();
                this.snapshotLastLogTerm = this.getTerm(this.snapshotLastLogIndex);
                this.collectTsFilesAndFillTimeseriesSchemas(requiredSlots);
                logger.info("{}: Snapshot is taken", (Object)this.getName());
            }
        }
        catch (EntryCompactedException e) {
            logger.error("failed to do snapshot.", (Throwable)e);
        }
        finally {
            super.resetBlockAppliedCommitIndex();
        }
    }

    private void collectTsFilesAndFillTimeseriesSchemas(List<Integer> requiredSlots) throws IOException {
        List<Integer> nodeSlots;
        this.collectTsFiles(requiredSlots);
        HashSet<Integer> slots = null;
        if (this.dataGroupMember.getMetaGroupMember() != null && (nodeSlots = ((SlotPartitionTable)this.dataGroupMember.getMetaGroupMember().getPartitionTable()).getNodeSlots(this.dataGroupMember.getHeader())) != null) {
            slots = new HashSet<Integer>(nodeSlots);
        }
        for (Map.Entry entry : this.slotTimeseries.entrySet()) {
            FileSnapshot snapshot;
            int slotNum = (Integer)entry.getKey();
            boolean slotExistsInPartition = slots == null || slots.contains(slotNum);
            if (!slotExistsInPartition || !(snapshot = this.slotSnapshots.computeIfAbsent(slotNum, s -> new FileSnapshot())).getTimeseriesSchemas().isEmpty()) continue;
            snapshot.setTimeseriesSchemas((Collection)entry.getValue());
        }
    }

    private void collectTsFiles(List<Integer> requiredSlots) throws IOException {
        this.slotSnapshots.clear();
        Map allClosedStorageGroupTsFile = StorageEngine.getInstance().getAllClosedStorageGroupTsFile();
        LinkedList<TsFileResource> createdHardlinks = new LinkedList<TsFileResource>();
        for (Map.Entry entry : allClosedStorageGroupTsFile.entrySet()) {
            PartialPath storageGroupName = (PartialPath)entry.getKey();
            Map storageGroupsFiles = (Map)entry.getValue();
            for (Map.Entry storageGroupFiles : storageGroupsFiles.entrySet()) {
                List resourceList;
                Long partitionNum = (Long)storageGroupFiles.getKey();
                if (this.collectTsFiles(partitionNum, resourceList = (List)storageGroupFiles.getValue(), storageGroupName, createdHardlinks, requiredSlots)) continue;
                for (TsFileResource createdHardlink : createdHardlinks) {
                    createdHardlink.remove();
                }
                this.collectTsFiles(requiredSlots);
                return;
            }
        }
    }

    private boolean collectTsFiles(Long partitionNum, List<TsFileResource> resourceList, PartialPath storageGroupName, List<TsFileResource> createdHardlinks, List<Integer> requiredSlots) throws IOException {
        int slotNum = SlotPartitionTable.getSlotStrategy().calculateSlotByPartitionNum(storageGroupName.getFullPath(), partitionNum, 10000);
        if (!requiredSlots.contains(slotNum)) {
            return true;
        }
        FileSnapshot snapshot = this.slotSnapshots.computeIfAbsent(slotNum, s -> new FileSnapshot());
        for (TsFileResource tsFileResource : resourceList) {
            TsFileResource hardlink = tsFileResource.createHardlink();
            if (hardlink == null) {
                return false;
            }
            createdHardlinks.add(hardlink);
            logger.debug("{}: File {} is put into snapshot #{}", new Object[]{this.getName(), tsFileResource, slotNum});
            snapshot.addFile(hardlink, this.thisNode, this.isPlanIndexRangeUnique(tsFileResource, resourceList));
        }
        snapshot.getDataFiles().sort(Comparator.comparingLong(TsFileResource::getMaxPlanIndex));
        return true;
    }

    private boolean isPlanIndexRangeUnique(TsFileResource resource, List<TsFileResource> others) {
        for (TsFileResource other : others) {
            if (other == resource || !other.isPlanIndexOverlap(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long append(Log entry) {
        long res = super.append(entry);
        if (entry instanceof AddNodeLog || entry instanceof RemoveNodeLog) {
            this.applyEntry(entry);
        }
        return res;
    }
}

