/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalFluxOperator;
import reactor.core.publisher.Operators;
import reactor.core.publisher.Traces;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

final class FluxOnAssembly<T>
extends InternalFluxOperator<T, T>
implements Fuseable,
AssemblyOp {
    final AssemblySnapshot snapshotStack;

    FluxOnAssembly(Flux<? extends T> source, AssemblySnapshot snapshotStack) {
        super(source);
        this.snapshotStack = snapshotStack;
    }

    @Override
    public String stepName() {
        return this.snapshotStack.operatorAssemblyInformation();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.ACTUAL_METADATA) {
            return !this.snapshotStack.checkpointed;
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public String toString() {
        return this.snapshotStack.operatorAssemblyInformation();
    }

    static void fillStacktraceHeader(StringBuilder sb, Class<?> sourceClass, @Nullable String description) {
        sb.append("\nAssembly trace from producer [").append(sourceClass.getName()).append("]");
        if (description != null) {
            sb.append(", described as [").append(description).append("]");
        }
        sb.append(" :\n");
    }

    static <T> CoreSubscriber<? super T> wrapSubscriber(CoreSubscriber<? super T> actual, Flux<? extends T> source, @Nullable AssemblySnapshot snapshotStack) {
        if (snapshotStack != null) {
            if (actual instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
                return new OnAssemblyConditionalSubscriber(cs, snapshotStack, (Publisher<?>)source);
            }
            return new OnAssemblySubscriber<T>(actual, snapshotStack, source);
        }
        return actual;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return FluxOnAssembly.wrapSubscriber(actual, this.source, this.snapshotStack);
    }

    static int getParentOrThis(Scannable parent) {
        return parent.parents().filter(s -> !(s instanceof AssemblyOp)).findFirst().map(Object::hashCode).orElse(parent.hashCode());
    }

    static final class OnAssemblyConditionalSubscriber<T>
    extends OnAssemblySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        final Fuseable.ConditionalSubscriber<? super T> actualCS;

        OnAssemblyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, AssemblySnapshot stacktrace, Publisher<?> parent) {
            super(actual, stacktrace, parent);
            this.actualCS = actual;
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.actualCS.tryOnNext(t);
        }
    }

    static class OnAssemblySubscriber<T>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final AssemblySnapshot snapshotStack;
        final Publisher<?> parent;
        final CoreSubscriber<? super T> actual;
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        int fusionMode;

        OnAssemblySubscriber(CoreSubscriber<? super T> actual, AssemblySnapshot snapshotStack, Publisher<?> parent) {
            this.actual = actual;
            this.snapshotStack = snapshotStack;
            this.parent = parent;
        }

        @Override
        public final CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.ACTUAL_METADATA) {
                return !this.snapshotStack.checkpointed;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public String toString() {
            return this.snapshotStack.operatorAssemblyInformation();
        }

        @Override
        public String stepName() {
            return this.toString();
        }

        public final void onNext(T t) {
            this.actual.onNext(t);
        }

        public final void onError(Throwable t) {
            this.actual.onError(this.fail(t));
        }

        public final void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public final int requestFusion(int requestedMode) {
            Fuseable.QueueSubscription<T> qs = this.qs;
            if (qs != null) {
                int m = qs.requestFusion(requestedMode);
                if (m != 0) {
                    this.fusionMode = m;
                }
                return m;
            }
            return 0;
        }

        final Throwable fail(Throwable t) {
            boolean lightCheckpoint = this.snapshotStack.isLight();
            OnAssemblyException onAssemblyException = null;
            for (Throwable e : t.getSuppressed()) {
                if (!(e instanceof OnAssemblyException)) continue;
                onAssemblyException = (OnAssemblyException)e;
                break;
            }
            if (onAssemblyException == null) {
                if (lightCheckpoint) {
                    onAssemblyException = new OnAssemblyException("");
                } else {
                    StringBuilder sb = new StringBuilder();
                    FluxOnAssembly.fillStacktraceHeader(sb, this.parent.getClass(), this.snapshotStack.getDescription());
                    sb.append(this.snapshotStack.toAssemblyInformation().replaceFirst("\\n$", ""));
                    String description = sb.toString();
                    onAssemblyException = new OnAssemblyException(description);
                }
                t = Exceptions.addSuppressed(t, (Throwable)onAssemblyException);
                StackTraceElement[] stackTrace = t.getStackTrace();
                if (stackTrace.length > 0) {
                    StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length];
                    int i = 0;
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        String className = stackTraceElement.getClassName();
                        if (className.startsWith("reactor.core.publisher.") && className.contains("OnAssembly")) continue;
                        newStackTrace[i] = stackTraceElement;
                        ++i;
                    }
                    newStackTrace = Arrays.copyOf(newStackTrace, i);
                    onAssemblyException.setStackTrace(newStackTrace);
                    t.setStackTrace(new StackTraceElement[]{stackTrace[0]});
                }
            }
            onAssemblyException.add(this.parent, this.snapshotStack);
            return t;
        }

        @Override
        public final boolean isEmpty() {
            try {
                return this.qs.isEmpty();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                throw Exceptions.propagate(this.fail(ex));
            }
        }

        @Override
        public final void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.qs = Operators.as(s);
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public final int size() {
            return this.qs.size();
        }

        @Override
        public final void clear() {
            this.qs.clear();
        }

        public final void request(long n) {
            this.s.request(n);
        }

        public final void cancel() {
            this.s.cancel();
        }

        @Override
        @Nullable
        public final T poll() {
            try {
                return (T)this.qs.poll();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                throw Exceptions.propagate(this.fail(ex));
            }
        }
    }

    static final class OnAssemblyException
    extends RuntimeException {
        final List<Tuple4<Integer, String, String, Integer>> chainOrder = new LinkedList<Tuple4<Integer, String, String, Integer>>();
        private static final long serialVersionUID = 5278398300974016773L;

        OnAssemblyException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        void add(Publisher<?> parent, AssemblySnapshot snapshot) {
            if (snapshot.isLight()) {
                this.add(parent, snapshot.lightPrefix(), snapshot.getDescription());
            } else {
                String assemblyInformation = snapshot.toAssemblyInformation();
                String[] parts = Traces.extractOperatorAssemblyInformationParts(assemblyInformation);
                if (parts.length > 0) {
                    String prefix = parts.length > 1 ? parts[0] : "";
                    String line = parts[parts.length - 1];
                    this.add(parent, prefix, line);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(Publisher<?> parent, String prefix, String line) {
            int key = FluxOnAssembly.getParentOrThis(Scannable.from(parent));
            List<Tuple4<Integer, String, String, Integer>> list = this.chainOrder;
            synchronized (list) {
                Tuple4<Integer, String, String, Integer> t;
                int i = 0;
                int n = this.chainOrder.size();
                for (int j = n - 1; j >= 0; --j) {
                    Tuple4<Integer, String, String, Integer> tmp = this.chainOrder.get(j);
                    if ((Integer)tmp.getT1() != key) continue;
                    i = tmp.getT4();
                    break;
                }
                while (true) {
                    if (!this.chainOrder.contains(t = Tuples.of(parent.hashCode(), prefix, line, i))) break;
                    ++i;
                }
                this.chainOrder.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            List<Tuple4<Integer, String, String, Integer>> list = this.chainOrder;
            synchronized (list) {
                if (this.chainOrder.isEmpty()) {
                    return super.getMessage();
                }
                int maxWidth = 0;
                for (Tuple4<Integer, String, String, Integer> t : this.chainOrder) {
                    int length = ((String)t.getT2()).length();
                    if (length <= maxWidth) continue;
                    maxWidth = length;
                }
                StringBuilder sb = new StringBuilder(super.getMessage()).append("\nError has been observed at the following site(s):\n");
                for (Tuple4<Integer, String, String, Integer> t : this.chainOrder) {
                    int i;
                    Integer indent = t.getT4();
                    String operator = (String)t.getT2();
                    String message = (String)t.getT3();
                    sb.append("\t|_");
                    for (i = 0; i < indent; ++i) {
                        sb.append("____");
                    }
                    for (i = operator.length(); i < maxWidth + 1; ++i) {
                        sb.append(' ');
                    }
                    sb.append(operator);
                    sb.append(" \u21e2 ");
                    sb.append(message);
                    sb.append("\n");
                }
                sb.append("Stack trace:");
                return sb.toString();
            }
        }
    }

    static final class MethodReturnSnapshot
    extends AssemblySnapshot {
        MethodReturnSnapshot(String method) {
            super(true, method, null);
            this.cached = method;
        }

        @Override
        public boolean isLight() {
            return true;
        }

        @Override
        String operatorAssemblyInformation() {
            return this.cached;
        }
    }

    static final class AssemblyLightSnapshot
    extends AssemblySnapshot {
        AssemblyLightSnapshot(@Nullable String description) {
            super(true, description, null);
            this.cached = "checkpoint(\"" + description + "\")";
        }

        @Override
        public boolean isLight() {
            return true;
        }

        @Override
        public String lightPrefix() {
            return "checkpoint";
        }

        @Override
        String operatorAssemblyInformation() {
            return this.cached;
        }
    }

    static class AssemblySnapshot {
        final boolean checkpointed;
        @Nullable
        final String description;
        final Supplier<String> assemblyInformationSupplier;
        String cached;

        AssemblySnapshot(@Nullable String description, Supplier<String> assemblyInformationSupplier) {
            this(description != null, description, assemblyInformationSupplier);
        }

        AssemblySnapshot(String assemblyInformation) {
            this.checkpointed = false;
            this.description = null;
            this.assemblyInformationSupplier = null;
            this.cached = assemblyInformation;
        }

        private AssemblySnapshot(boolean checkpointed, @Nullable String description, Supplier<String> assemblyInformationSupplier) {
            this.checkpointed = checkpointed;
            this.description = description;
            this.assemblyInformationSupplier = assemblyInformationSupplier;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public boolean isLight() {
            return false;
        }

        public String lightPrefix() {
            return "";
        }

        String toAssemblyInformation() {
            if (this.cached == null) {
                this.cached = this.assemblyInformationSupplier.get();
            }
            return this.cached;
        }

        String operatorAssemblyInformation() {
            return Traces.extractOperatorAssemblyInformation(this.toAssemblyInformation());
        }
    }
}

