/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.config.IConfig;

class BrokerConfiguration {
    private final boolean allowAnonymous;
    private final boolean allowZeroByteClientId;
    private final boolean reauthorizeSubscriptionsOnConnect;
    private final boolean immediateBufferFlush;

    BrokerConfiguration(IConfig props) {
        this.allowAnonymous = props.boolProp("allow_anonymous", true);
        this.allowZeroByteClientId = props.boolProp("allow_zero_byte_client_id", false);
        this.reauthorizeSubscriptionsOnConnect = props.boolProp("reauthorize_subscriptions_on_connect", false);
        this.immediateBufferFlush = props.boolProp("immediate_buffer_flush", false);
    }

    public BrokerConfiguration(boolean allowAnonymous, boolean allowZeroByteClientId, boolean reauthorizeSubscriptionsOnConnect, boolean immediateBufferFlush) {
        this.allowAnonymous = allowAnonymous;
        this.allowZeroByteClientId = allowZeroByteClientId;
        this.reauthorizeSubscriptionsOnConnect = reauthorizeSubscriptionsOnConnect;
        this.immediateBufferFlush = immediateBufferFlush;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public boolean isAllowZeroByteClientId() {
        return this.allowZeroByteClientId;
    }

    public boolean isReauthorizeSubscriptionsOnConnect() {
        return this.reauthorizeSubscriptionsOnConnect;
    }

    public boolean isImmediateBufferFlush() {
        return this.immediateBufferFlush;
    }
}

