/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class SchemaFetchScanOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final PathPatternTree patternTree;
    private final Map<Integer, Template> templateMap;
    private final ISchemaRegion schemaRegion;
    private final boolean withTags;
    private final boolean withAttributes;
    private final boolean withTemplate;
    private final boolean withAliasForce;
    private final boolean fetchDevice;
    private boolean isFinished = false;
    private final PathPatternTree authorityScope;
    private Iterator<SchemaNode> schemaNodeIteratorForSerialize = null;
    private long schemaTreeMemCost;
    private PublicBAOS baos = null;
    private static final int EXTRA_SIZE_TO_AVOID_GROW = 1024;
    private static int DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SchemaFetchScanOperator.class);

    public static SchemaFetchScanOperator ofSeries(PlanNodeId planNodeId, OperatorContext context, PathPatternTree patternTree, Map<Integer, Template> templateMap, ISchemaRegion schemaRegion, boolean withTags, boolean withAttributes, boolean withTemplate, boolean withAliasForce) {
        return new SchemaFetchScanOperator(planNodeId, context, patternTree, templateMap, schemaRegion, withTags, withAttributes, withTemplate, withAliasForce);
    }

    public static SchemaFetchScanOperator ofDevice(PlanNodeId planNodeId, OperatorContext context, PathPatternTree patternTree, PathPatternTree authorityScope, ISchemaRegion schemaRegion) {
        return new SchemaFetchScanOperator(planNodeId, context, patternTree, authorityScope, schemaRegion);
    }

    private SchemaFetchScanOperator(PlanNodeId planNodeId, OperatorContext context, PathPatternTree patternTree, Map<Integer, Template> templateMap, ISchemaRegion schemaRegion, boolean withTags, boolean withAttributes, boolean withTemplate, boolean withAliasForce) {
        this.sourceId = planNodeId;
        this.operatorContext = context;
        this.patternTree = patternTree;
        this.schemaRegion = schemaRegion;
        this.templateMap = templateMap;
        this.withTags = withTags;
        this.withAttributes = withAttributes;
        this.withTemplate = withTemplate;
        this.withAliasForce = withAliasForce;
        this.fetchDevice = false;
        this.authorityScope = SchemaConstant.ALL_MATCH_SCOPE;
    }

    private SchemaFetchScanOperator(PlanNodeId planNodeId, OperatorContext context, PathPatternTree patternTree, PathPatternTree authorityScope, ISchemaRegion schemaRegion) {
        this.sourceId = planNodeId;
        this.operatorContext = context;
        this.patternTree = patternTree;
        this.schemaRegion = schemaRegion;
        this.templateMap = Collections.emptyMap();
        this.withTags = false;
        this.withAttributes = false;
        this.withTemplate = false;
        this.withAliasForce = false;
        this.fetchDevice = true;
        this.authorityScope = authorityScope;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        boolean isFirstBatch = this.schemaNodeIteratorForSerialize == null;
        this.prepareSchemaNodeIteratorForSerialize();
        ReadWriteIOUtils.write((byte)2, (OutputStream)this.baos);
        if (isFirstBatch) {
            ReadWriteIOUtils.write((long)this.schemaTreeMemCost, (OutputStream)this.baos);
        }
        while (this.schemaNodeIteratorForSerialize.hasNext() && this.baos.size() < DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES) {
            SchemaNode node = this.schemaNodeIteratorForSerialize.next();
            node.serializeNodeOwnContent((OutputStream)this.baos);
        }
        byte[] currentBatch = this.baos.toByteArray();
        this.baos.reset();
        boolean bl = this.isFinished = !this.schemaNodeIteratorForSerialize.hasNext();
        if (this.isFinished) {
            currentBatch[0] = 3;
            this.releaseSchemaTree();
            this.baos = null;
        }
        return new TsBlock(new TimeColumn(1, new long[]{0L}), new Column[]{new BinaryColumn(1, Optional.empty(), new Binary[]{new Binary(currentBatch)})});
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.isFinished;
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.isFinished;
    }

    @Override
    public void close() throws Exception {
        this.releaseSchemaTree();
        this.baos = null;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    private void prepareSchemaNodeIteratorForSerialize() {
        if (this.schemaNodeIteratorForSerialize != null) {
            return;
        }
        try {
            ClusterSchemaTree schemaTree = this.fetchDevice ? this.schemaRegion.fetchDeviceSchema(this.patternTree, this.authorityScope) : this.schemaRegion.fetchSeriesSchema(this.patternTree, this.templateMap, this.withTags, this.withAttributes, this.withTemplate, this.withAliasForce);
            this.schemaNodeIteratorForSerialize = schemaTree.getIteratorForSerialize();
            this.baos = new PublicBAOS(DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + 1024);
            if (this.operatorContext != null) {
                long ramBytesUsed = schemaTree.ramBytesUsed();
                this.operatorContext.getInstanceContext().getMemoryReservationContext().reserveMemoryCumulatively(ramBytesUsed);
                this.operatorContext.getInstanceContext().getMemoryReservationContext().reserveMemoryImmediately();
                this.schemaTreeMemCost = ramBytesUsed;
            }
        }
        catch (MetadataException e) {
            throw new SchemaExecutionException((Throwable)e);
        }
    }

    @Override
    public long calculateMaxPeekMemory() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + (long)DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + 1024L + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.sourceId);
    }

    private void releaseSchemaTree() {
        if (this.schemaTreeMemCost <= 0L || this.operatorContext == null) {
            return;
        }
        this.operatorContext.getInstanceContext().getMemoryReservationContext().releaseMemoryCumulatively(this.schemaTreeMemCost);
        this.schemaTreeMemCost = 0L;
        this.schemaNodeIteratorForSerialize = null;
    }

    public static void setDefaultMaxTsBlockSizeInBytes(int newSize) {
        DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES = newSize;
    }
}

