/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.exception.metadata.view.InsertNonWritableViewException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceNormalSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DeviceTemplateSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.IDeviceSchema;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.SchemaCacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class DataNodeSchemaCache {
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    private final DeviceSchemaCache deviceSchemaCache = new DeviceSchemaCache();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(false);

    private DataNodeSchemaCache() {
    }

    public static DataNodeSchemaCache getInstance() {
        return DataNodeSchemaCacheHolder.INSTANCE;
    }

    public void takeReadLock() {
        this.readWriteLock.readLock().lock();
    }

    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    public void takeWriteLock() {
        this.readWriteLock.writeLock().lock();
    }

    public void releaseWriteLock() {
        this.readWriteLock.writeLock().unlock();
    }

    public ClusterSchemaTree get(PartialPath devicePath, String[] measurements) {
        ClusterSchemaTree tree = new ClusterSchemaTree();
        IDeviceSchema schema = this.deviceSchemaCache.getDeviceSchema(devicePath);
        if (!(schema instanceof DeviceNormalSchema)) {
            return tree;
        }
        DeviceNormalSchema treeSchema = (DeviceNormalSchema)schema;
        for (String measurement : measurements) {
            SchemaCacheEntry entry = treeSchema.getSchemaCacheEntry(measurement);
            if (!Objects.nonNull(entry)) continue;
            tree.appendSingleMeasurement(devicePath.concatNode(measurement), entry.getSchema(), entry.getTagMap(), null, null, treeSchema.isAligned());
        }
        tree.setDatabases(Collections.singleton(treeSchema.getDatabase()));
        return tree;
    }

    public ClusterSchemaTree getMatchedTemplateSchema(PartialPath devicePath) {
        ClusterSchemaTree tree = new ClusterSchemaTree();
        IDeviceSchema schema = this.deviceSchemaCache.getDeviceSchema(devicePath);
        if (!(schema instanceof DeviceTemplateSchema)) {
            return tree;
        }
        DeviceTemplateSchema treeSchema = (DeviceTemplateSchema)schema;
        Template template = this.templateManager.getTemplate(treeSchema.getTemplateId());
        tree.appendTemplateDevice(devicePath, template.isDirectAligned(), template.getId(), template);
        tree.setDatabases(Collections.singleton(treeSchema.getDatabase()));
        return tree;
    }

    public ClusterSchemaTree getMatchedNormalSchema(PartialPath fullPath) {
        ClusterSchemaTree tree = new ClusterSchemaTree();
        IDeviceSchema schema = this.deviceSchemaCache.getDeviceSchema(fullPath.getDevicePath());
        if (!(schema instanceof DeviceNormalSchema)) {
            return tree;
        }
        DeviceNormalSchema treeSchema = (DeviceNormalSchema)schema;
        SchemaCacheEntry entry = treeSchema.getSchemaCacheEntry(fullPath.getMeasurement());
        if (Objects.isNull(entry)) {
            return tree;
        }
        tree.appendSingleMeasurement(fullPath, entry.getSchema(), entry.getTagMap(), null, null, treeSchema.isAligned());
        tree.setDatabases(Collections.singleton(treeSchema.getDatabase()));
        return tree;
    }

    public List<Integer> computeWithoutTemplate(ISchemaComputation schemaComputation) {
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        String[] measurements = schemaComputation.getMeasurements();
        IDeviceSchema schema = this.deviceSchemaCache.getDeviceSchema(schemaComputation.getDevicePath());
        if (!(schema instanceof DeviceNormalSchema)) {
            return IntStream.range(0, schemaComputation.getMeasurements().length).boxed().collect(Collectors.toList());
        }
        DeviceNormalSchema treeSchema = (DeviceNormalSchema)schema;
        for (int i = 0; i < schemaComputation.getMeasurements().length; ++i) {
            SchemaCacheEntry value = treeSchema.getSchemaCacheEntry(measurements[i]);
            if (value == null) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            schemaComputation.computeMeasurement(i, value);
        }
        schemaComputation.computeDevice(treeSchema.isAligned());
        schemaComputation.recordRangeOfLogicalViewSchemaListNow();
        return indexOfMissingMeasurements;
    }

    public Pair<List<Integer>, List<String>> computeSourceOfLogicalView(ISchemaComputation schemaComputation) {
        if (!schemaComputation.hasLogicalViewNeedProcess()) {
            return new Pair(new ArrayList(), new ArrayList());
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        Pair<Integer, Integer> beginToEnd = schemaComputation.getRangeOfLogicalViewSchemaListRecorded();
        List<LogicalViewSchema> logicalViewSchemaList = schemaComputation.getLogicalViewSchemaList();
        List<Integer> indexListOfLogicalViewPaths = schemaComputation.getIndexListOfLogicalViewPaths();
        for (int i = ((Integer)beginToEnd.left).intValue(); i < (Integer)beginToEnd.right; ++i) {
            LogicalViewSchema logicalViewSchema = logicalViewSchemaList.get(i);
            int realIndex = indexListOfLogicalViewPaths.get(i);
            if (!logicalViewSchema.isWritable()) {
                throw new RuntimeException((Throwable)((Object)new InsertNonWritableViewException(schemaComputation.getDevicePath().concatAsMeasurementPath(schemaComputation.getMeasurements()[realIndex]).getFullPath())));
            }
            PartialPath fullPath = logicalViewSchema.getSourcePathIfWritable();
            IDeviceSchema schema = this.deviceSchemaCache.getDeviceSchema(fullPath.getDevicePath());
            if (!(schema instanceof DeviceNormalSchema)) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            DeviceNormalSchema treeSchema = (DeviceNormalSchema)schema;
            SchemaCacheEntry value = treeSchema.getSchemaCacheEntry(fullPath.getMeasurement());
            if (Objects.isNull(value)) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            if (value.isLogicalView()) {
                throw new RuntimeException(new UnsupportedOperationException(String.format("The source of view [%s] is also a view! Nested view is unsupported! Please check it.", logicalViewSchema.getSourcePathIfWritable())));
            }
            schemaComputation.computeMeasurementOfView(realIndex, value, treeSchema.isAligned());
        }
        return new Pair(indexOfMissingMeasurements, indexOfMissingMeasurements.stream().map(index -> ((LogicalViewSchema)logicalViewSchemaList.get((int)index)).getSourcePathStringIfWritable()).collect(Collectors.toList()));
    }

    public List<Integer> computeWithTemplate(ISchemaComputation computation) {
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        String[] measurements = computation.getMeasurements();
        IDeviceSchema deviceSchema = this.deviceSchemaCache.getDeviceSchema(computation.getDevicePath());
        if (!(deviceSchema instanceof DeviceTemplateSchema)) {
            return IntStream.range(0, measurements.length).boxed().collect(Collectors.toList());
        }
        DeviceTemplateSchema deviceTemplateSchema = (DeviceTemplateSchema)deviceSchema;
        Template template = this.templateManager.getTemplate(deviceTemplateSchema.getTemplateId());
        computation.computeDevice(template.isDirectAligned());
        Map<String, IMeasurementSchema> templateSchema = template.getSchemaMap();
        for (int i = 0; i < measurements.length; ++i) {
            if (!templateSchema.containsKey(measurements[i])) {
                indexOfMissingMeasurements.add(i);
                continue;
            }
            IMeasurementSchema schema = templateSchema.get(measurements[i]);
            computation.computeMeasurement(i, new WrappedSchemaInfo(schema));
        }
        return indexOfMissingMeasurements;
    }

    public void put(ClusterSchemaTree tree) {
        tree.getAllDevices().forEach(deviceSchemaInfo -> this.deviceSchemaCache.putDeviceSchema(tree.getBelongedDatabase(deviceSchemaInfo.getDevicePath()), (DeviceSchemaInfo)deviceSchemaInfo));
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        return this.deviceSchemaCache.getLastEntry(seriesPath.getDevicePath(), seriesPath.getMeasurement());
    }

    public void invalidateLastCache(PartialPath path) {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            return;
        }
        this.deviceSchemaCache.invalidateLastCache(path.getDevicePath(), path.getMeasurement());
    }

    public void invalidateDatabaseLastCache(String database) {
        if (!CommonDescriptor.getInstance().getConfig().isLastCacheEnable()) {
            return;
        }
        this.deviceSchemaCache.invalidateLastCache(database);
    }

    public void updateLastCacheIfExists(String database, PartialPath deviceID, String[] measurements, @Nonnull TimeValuePair[] timeValuePairs, boolean isAligned, IMeasurementSchema[] measurementSchemas) {
        this.deviceSchemaCache.updateLastCache(database, deviceID, measurements, timeValuePairs, isAligned, measurementSchemas, false);
    }

    public void declareLastCache(String database, MeasurementPath measurementPath) {
        this.deviceSchemaCache.updateLastCache(database, measurementPath.getDevicePath(), new String[]{measurementPath.getMeasurement()}, null, measurementPath.isUnderAlignedEntity(), new IMeasurementSchema[]{measurementPath.getMeasurementSchema()}, true);
    }

    public void invalidateLastCache(String database, MeasurementPath measurementPath) {
        this.deviceSchemaCache.updateLastCache(database, measurementPath.getDevicePath(), new String[]{measurementPath.getMeasurement()}, new TimeValuePair[]{null}, measurementPath.isUnderAlignedEntity(), new IMeasurementSchema[]{measurementPath.getMeasurementSchema()}, true);
    }

    public void invalidate(List<PartialPath> partialPathList) {
        partialPathList.forEach(measurementPath -> {
            boolean isMultiLevelWildcardMeasurement = PathPatternUtil.isMultiLevelMatchWildcard((String)measurementPath.getMeasurement());
            this.deviceSchemaCache.invalidateCache(isMultiLevelWildcardMeasurement ? measurementPath : measurementPath.getDevicePath(), isMultiLevelWildcardMeasurement);
        });
    }

    public DeviceSchemaCache getDeviceSchemaCache() {
        return this.deviceSchemaCache;
    }

    public void cleanUp() {
        this.deviceSchemaCache.invalidateAll();
    }

    private static class DataNodeSchemaCacheHolder {
        private static final DataNodeSchemaCache INSTANCE = new DataNodeSchemaCache();

        private DataNodeSchemaCacheHolder() {
        }
    }

    private static class WrappedSchemaInfo
    implements IMeasurementSchemaInfo {
        private final IMeasurementSchema schema;

        public WrappedSchemaInfo(IMeasurementSchema schema) {
            this.schema = schema;
        }

        @Override
        public String getName() {
            return this.schema.getMeasurementId();
        }

        @Override
        public IMeasurementSchema getSchema() {
            if (this.isLogicalView()) {
                return new LogicalViewSchema(this.schema.getMeasurementId(), ((LogicalViewSchema)this.schema).getExpression());
            }
            return this.getSchemaAsMeasurementSchema();
        }

        @Override
        public MeasurementSchema getSchemaAsMeasurementSchema() {
            return new MeasurementSchema(this.schema.getMeasurementId(), this.schema.getType(), this.schema.getEncodingType(), this.schema.getCompressor());
        }

        @Override
        public LogicalViewSchema getSchemaAsLogicalViewSchema() {
            throw new RuntimeException(new UnsupportedOperationException("Function getSchemaAsLogicalViewSchema is not supported in DeviceUsingTemplateSchemaCache."));
        }

        @Override
        public Map<String, String> getTagMap() {
            return null;
        }

        @Override
        public Map<String, String> getAttributeMap() {
            return null;
        }

        @Override
        public String getAlias() {
            return null;
        }

        @Override
        public boolean isLogicalView() {
            return this.schema.isLogicalView();
        }
    }
}

