/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;
import org.apache.iotdb.commons.utils.PathUtils;

public class PrefixPipePattern
extends PipePattern {
    private final String pattern;

    public PrefixPipePattern(String pattern) {
        this.pattern = pattern != null ? pattern : this.getDefaultPattern();
    }

    private String getDefaultPattern() {
        return "root";
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isRoot() {
        return Objects.isNull(this.pattern) || this.pattern.equals(this.getDefaultPattern());
    }

    @Override
    public boolean isLegal() {
        if (!this.pattern.startsWith("root")) {
            return false;
        }
        try {
            PathUtils.isLegalPath(this.pattern);
        }
        catch (IllegalPathException e) {
            try {
                if ("root".equals(this.pattern) || "root.".equals(this.pattern)) {
                    return true;
                }
                String[] pathNodes = StringUtils.splitPreserveAllTokens((String)this.pattern, (String)"\\.");
                PathUtils.splitPathToDetachedNodes(String.join((CharSequence)".", Arrays.copyOfRange(pathNodes, 0, pathNodes.length - 1)));
                String lastNode = pathNodes[pathNodes.length - 1];
                if (!"".equals(lastNode)) {
                    Double.parseDouble(lastNode);
                }
            }
            catch (Exception ignored) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean coversDb(String db) {
        return this.pattern.length() <= db.length() && db.startsWith(this.pattern);
    }

    @Override
    public boolean coversDevice(String device) {
        return this.pattern.length() <= device.length() && device.startsWith(this.pattern);
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        return this.pattern.length() <= device.length() && device.startsWith(this.pattern) || this.pattern.length() > device.length() && this.pattern.startsWith(device);
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        return this.pattern.length() <= db.length() && db.startsWith(this.pattern) || this.pattern.length() > db.length() && this.pattern.startsWith(db);
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        if (this.pattern.length() <= device.length()) {
            return true;
        }
        String dotAndMeasurement = "." + measurement;
        return this.pattern.length() <= device.length() + dotAndMeasurement.length() && dotAndMeasurement.startsWith(this.pattern.substring(device.length()));
    }

    @Override
    public List<PartialPath> getBaseInclusionPaths() {
        if (this.isRoot()) {
            return Collections.singletonList(new PartialPath(new String[]{"root", "**"}));
        }
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        try {
            paths.add(new PartialPath(this.pattern));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        try {
            paths.add(new PartialPath(this.pattern + "*"));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        try {
            paths.add(new PartialPath(this.pattern + "." + "**"));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        try {
            paths.add(new PartialPath(this.pattern + "*" + "." + "**"));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
        return paths;
    }

    public String toString() {
        return "PrefixPipePattern{pattern='" + this.pattern + "'}";
    }
}

