/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.schematree.node;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.queryengine.common.schematree.IMeasurementSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.node.SchemaNode;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchemaType;

public class SchemaMeasurementNode
extends SchemaNode
implements IMeasurementSchemaInfo {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(SchemaMeasurementNode.class);
    private String alias;
    private IMeasurementSchema schema;
    private Map<String, String> tagMap;
    private Map<String, String> attributeMap;

    public SchemaMeasurementNode(String name, IMeasurementSchema schema) {
        super(name);
        this.schema = schema;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.name) + RamUsageEstimator.sizeOf((String)this.alias) + this.schema.ramBytesUsed() + RamUsageEstimator.sizeOfMapWithKnownShallowSize(this.tagMap, (long)RamUsageEstimator.SHALLOW_SIZE_OF_HASHMAP, (long)RamUsageEstimator.SHALLOW_SIZE_OF_HASHMAP_ENTRY) + RamUsageEstimator.sizeOfMapWithKnownShallowSize(this.attributeMap, (long)RamUsageEstimator.SHALLOW_SIZE_OF_HASHMAP, (long)RamUsageEstimator.SHALLOW_SIZE_OF_HASHMAP_ENTRY);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public boolean isLogicalView() {
        return this.schema.isLogicalView();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public IMeasurementSchema getSchema() {
        return this.schema;
    }

    @Override
    public MeasurementSchema getSchemaAsMeasurementSchema() {
        if (this.schema instanceof MeasurementSchema) {
            return (MeasurementSchema)this.getSchema();
        }
        return null;
    }

    @Override
    public LogicalViewSchema getSchemaAsLogicalViewSchema() {
        if (this.schema instanceof LogicalViewSchema) {
            return (LogicalViewSchema)this.getSchema();
        }
        return null;
    }

    @Override
    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public Map<String, String> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, String> attributeMap) {
        this.attributeMap = attributeMap;
    }

    @Override
    public SchemaNode getChild(String name) {
        return null;
    }

    @Override
    public void replaceChild(String name, SchemaNode newChild) {
        throw new UnsupportedOperationException("This operation is not supported in SchemaMeasurementNode.");
    }

    @Override
    public void removeChild(String name) {
        throw new UnsupportedOperationException("Remove child operation is not supported in SchemaMeasurementNode.");
    }

    @Override
    public void copyDataTo(SchemaNode schemaNode) {
        if (!schemaNode.isMeasurement()) {
            return;
        }
        SchemaMeasurementNode measurementNode = schemaNode.getAsMeasurementNode();
        measurementNode.setSchema(this.schema);
        measurementNode.setAlias(this.alias);
    }

    private void setSchema(IMeasurementSchema schema) {
        this.schema = schema;
    }

    public void setTagMap(Map<String, String> tagMap) {
        this.tagMap = tagMap;
    }

    @Override
    public boolean isMeasurement() {
        return true;
    }

    @Override
    public SchemaMeasurementNode getAsMeasurementNode() {
        return this;
    }

    @Override
    public byte getType() {
        return 2;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeNodeOwnContent(outputStream);
    }

    @Override
    public void serializeNodeOwnContent(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.getType(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.name, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.alias, (OutputStream)outputStream);
        MeasurementSchemaType measurementSchemaType = this.schema.getSchemaType();
        ReadWriteIOUtils.write((byte)measurementSchemaType.getMeasurementSchemaTypeInByteEnum(), (OutputStream)outputStream);
        this.schema.serializeTo(outputStream);
        ReadWriteIOUtils.write(this.tagMap, (OutputStream)outputStream);
        ReadWriteIOUtils.write(this.attributeMap, (OutputStream)outputStream);
    }

    public static SchemaMeasurementNode deserialize(InputStream inputStream) throws IOException {
        String name = ReadWriteIOUtils.readString((InputStream)inputStream);
        String alias = ReadWriteIOUtils.readString((InputStream)inputStream);
        MeasurementSchema schema = null;
        byte measurementSchemaType = ReadWriteIOUtils.readByte((InputStream)inputStream);
        if (measurementSchemaType == MeasurementSchemaType.MEASUREMENT_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
            schema = MeasurementSchema.deserializeFrom((InputStream)inputStream);
        } else if (measurementSchemaType == MeasurementSchemaType.LOGICAL_VIEW_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
            schema = LogicalViewSchema.deserializeFrom((InputStream)inputStream);
        }
        Map tagMap = ReadWriteIOUtils.readMap((InputStream)inputStream);
        Map attributeMap = ReadWriteIOUtils.readMap((InputStream)inputStream);
        SchemaMeasurementNode measurementNode = new SchemaMeasurementNode(name, (IMeasurementSchema)schema);
        measurementNode.setAlias(alias);
        measurementNode.setTagMap(tagMap);
        measurementNode.setAttributeMap(attributeMap);
        return measurementNode;
    }
}

