/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata.pipe;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class ShowPipesStatement
extends ShowStatement
implements IConfigStatement {
    private String pipeName;
    private boolean whereClause;

    public ShowPipesStatement() {
        this.statementType = StatementType.SHOW_PIPES;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public boolean getWhereClause() {
        return this.whereClause;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public void setWhereClause(boolean whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.READ;
    }

    @Override
    public TSStatus checkPermissionBeforeProcess(String userName) {
        if (AuthorityChecker.SUPER_USER.equals(userName)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return AuthorityChecker.getTSStatus(AuthorityChecker.checkSystemPermission(userName, PrivilegeType.USE_PIPE.ordinal()), PrivilegeType.USE_PIPE);
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitShowPipes(this, context);
    }
}

