/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemPageReader;
import org.apache.iotdb.db.utils.datastructure.MemPointIterator;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.BatchData;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IChunkReader;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.IPointReader;

public class MemChunkReader
implements IChunkReader,
IPointReader {
    private final MemPointIterator timeValuePairIterator;
    private final Filter globalTimeFilter;
    private final List<IPageReader> pageReaderList;
    private boolean hasCachedTimeValuePair;
    private TimeValuePair cachedTimeValuePair;

    public MemChunkReader(ReadOnlyMemChunk readableChunk, Filter globalTimeFilter) {
        this.timeValuePairIterator = readableChunk.getMemPointIterator();
        this.globalTimeFilter = globalTimeFilter;
        this.pageReaderList = new ArrayList<IPageReader>();
        this.initAllPageReaders(readableChunk.getChunkMetaData(), readableChunk.getPageStatisticsList());
    }

    private void initAllPageReaders(IChunkMetadata metadata, List<Statistics<? extends Serializable>> pageStats) {
        TsBlockSupplier tsBlockSupplier = new TsBlockSupplier();
        for (int pageIndex = 0; pageIndex < pageStats.size(); ++pageIndex) {
            MemPageReader pageReader = new MemPageReader(tsBlockSupplier, pageIndex, metadata.getDataType(), metadata.getMeasurementUid(), pageStats.get(pageIndex), this.globalTimeFilter);
            this.pageReaderList.add(pageReader);
        }
    }

    public boolean hasNextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            return true;
        }
        while (this.timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            if (this.globalTimeFilter != null && !this.globalTimeFilter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            this.hasCachedTimeValuePair = true;
            this.cachedTimeValuePair = timeValuePair;
            break;
        }
        return this.hasCachedTimeValuePair;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            return this.cachedTimeValuePair;
        }
        return this.timeValuePairIterator.nextTimeValuePair();
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        if (!this.hasCachedTimeValuePair) {
            this.cachedTimeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            this.hasCachedTimeValuePair = true;
        }
        return this.cachedTimeValuePair;
    }

    public boolean hasNextSatisfiedPage() throws IOException {
        return this.hasNextTimeValuePair();
    }

    public BatchData nextPageData() throws IOException {
        return this.pageReaderList.remove(0).getAllSatisfiedPageData();
    }

    public long getUsedMemorySize() {
        return this.timeValuePairIterator.getUsedMemorySize();
    }

    public void close() {
    }

    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }

    class TsBlockSupplier
    implements Supplier<TsBlock> {
        private int tsBlockIndex;

        public void setTsBlockIndex(int tsBlockIndex) {
            this.tsBlockIndex = tsBlockIndex;
        }

        @Override
        public TsBlock get() {
            return MemChunkReader.this.timeValuePairIterator.getBatch(this.tsBlockIndex);
        }
    }
}

