/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RelativePath
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=540");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=541");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=542");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15189");
    private final RelativePathElement[] elements;

    public RelativePath(RelativePathElement[] elements) {
        this.elements = elements;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public RelativePathElement[] getElements() {
        return this.elements;
    }

    protected RelativePath(RelativePathBuilder<?, ?> b) {
        super(b);
        this.elements = ((RelativePathBuilder)b).elements;
    }

    public static RelativePathBuilder<?, ?> builder() {
        return new RelativePathBuilderImpl();
    }

    public RelativePathBuilder<?, ?> toBuilder() {
        return new RelativePathBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelativePath)) {
            return false;
        }
        RelativePath other = (RelativePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getElements(), other.getElements());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelativePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getElements());
        return result;
    }

    @Override
    public String toString() {
        return "RelativePath(elements=" + Arrays.deepToString(this.getElements()) + ")";
    }

    private static final class RelativePathBuilderImpl
    extends RelativePathBuilder<RelativePath, RelativePathBuilderImpl> {
        private RelativePathBuilderImpl() {
        }

        @Override
        protected RelativePathBuilderImpl self() {
            return this;
        }

        @Override
        public RelativePath build() {
            return new RelativePath(this);
        }
    }

    public static abstract class RelativePathBuilder<C extends RelativePath, B extends RelativePathBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RelativePathElement[] elements;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RelativePathBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RelativePath instance, RelativePathBuilder<?, ?> b) {
            b.elements(instance.elements);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B elements(RelativePathElement[] elements) {
            this.elements = elements;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RelativePath.RelativePathBuilder(super=" + super.toString() + ", elements=" + Arrays.deepToString(this.elements) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RelativePath> {
        @Override
        public Class<RelativePath> getType() {
            return RelativePath.class;
        }

        @Override
        public RelativePath decode(SerializationContext context, UaDecoder decoder) {
            RelativePathElement[] elements = (RelativePathElement[])decoder.readStructArray("Elements", RelativePathElement.TYPE_ID);
            return new RelativePath(elements);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RelativePath value) {
            encoder.writeStructArray("Elements", (Object[])value.getElements(), RelativePathElement.TYPE_ID);
        }
    }
}

