/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.tsfile.encoding.encoder.TSEncodingBuilder;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertNodeMemoryEstimator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertNodeMemoryEstimator.class);
    private static final String INSERT_TABLET_NODE = "InsertTabletNode";
    private static final String INSERT_ROW_NODE = "InsertRowNode";
    private static final String INSERT_ROWS_NODE = "InsertRowsNode";
    private static final String INSERT_ROWS_OF_ONE_DEVICE_NODE = "InsertRowsOfOneDeviceNode";
    private static final String INSERT_MULTI_TABLETS_NODE = "InsertMultiTabletsNode";
    private static final String RELATIONAL_INSERT_ROWS_NODE = "RelationalInsertRowsNode";
    private static final String RELATIONAL_INSERT_ROW_NODE = "RelationalInsertRowNode";
    private static final String RELATIONAL_INSERT_TABLET_NODE = "RelationalInsertTabletNode";
    private static final long NUM_BYTES_OBJECT_REF = RamUsageEstimator.NUM_BYTES_OBJECT_REF;
    private static final long NUM_BYTES_OBJECT_HEADER = RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
    private static final long NUM_BYTES_ARRAY_HEADER = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private static final long TS_ENCODING_PLAIN_BUILDER_SIZE = RamUsageEstimator.shallowSizeOf((Object)TSEncodingBuilder.getEncodingBuilder((TSEncoding)TSEncoding.PLAIN));
    private static final long INSERT_TABLET_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertTabletNode.class);
    private static final long INSERT_ROW_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowNode.class);
    private static final long INSERT_ROWS_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowsNode.class);
    private static final long INSERT_ROWS_OF_ONE_DEVICE_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertRowsOfOneDeviceNode.class);
    private static final long INSERT_MULTI_TABLETS_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InsertMultiTabletsNode.class);
    private static final long RELATIONAL_INSERT_ROWS_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(RelationalInsertRowsNode.class);
    private static final long RELATIONAL_INSERT_ROW_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(RelationalInsertRowNode.class);
    private static final long RELATIONAL_INSERT_TABLET_NODE_SIZE = RamUsageEstimator.shallowSizeOfInstance(RelationalInsertTabletNode.class);
    private static final long PARTIAL_PATH_SIZE = RamUsageEstimator.shallowSizeOfInstance(PartialPath.class);
    private static final long MEASUREMENT_SCHEMA_SIZE = RamUsageEstimator.shallowSizeOfInstance(MeasurementSchema.class);
    private static final long T_REGION_REPLICA_SET_SIZE = RamUsageEstimator.shallowSizeOfInstance(TRegionReplicaSet.class);
    private static final long T_DATA_NODE_LOCATION_SIZE = RamUsageEstimator.shallowSizeOfInstance(TDataNodeLocation.class);
    private static final long TS_STATUS_SIZE = RamUsageEstimator.shallowSizeOfInstance(TSStatus.class);
    private static final long T_END_POINT_SIZE = RamUsageEstimator.shallowSizeOfInstance(TEndPoint.class);
    private static final long T_CONSENSUS_GROUP_ID_SIZE = RamUsageEstimator.shallowSizeOfInstance(TConsensusGroupId.class);
    private static final long BIT_MAP_SIZE = RamUsageEstimator.shallowSizeOfInstance(BitMap.class);
    private static final long SIZE_OF_LONG = RamUsageEstimator.alignObjectSize((long)(8L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_INT = RamUsageEstimator.alignObjectSize((long)(4L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_DOUBLE = RamUsageEstimator.alignObjectSize((long)(8L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_FLOAT = RamUsageEstimator.alignObjectSize((long)(4L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_BOOLEAN = RamUsageEstimator.alignObjectSize((long)(1L + NUM_BYTES_OBJECT_HEADER));
    private static final long SIZE_OF_STRING = RamUsageEstimator.shallowSizeOfInstance(String.class);
    private static final long SIZE_OF_ARRAYLIST = RamUsageEstimator.shallowSizeOfInstance(ArrayList.class);
    private static final double INSERT_ROW_NODE_EXPANSION_FACTOR = 1.3;

    public static long sizeOf(InsertNode insertNode) {
        try {
            String className;
            switch (className = insertNode.getClass().getSimpleName()) {
                case "InsertTabletNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertTabletNode((InsertTabletNode)insertNode);
                }
                case "InsertRowNode": {
                    return (long)((double)InsertNodeMemoryEstimator.sizeOfInsertRowNode((InsertRowNode)insertNode) * 1.3);
                }
                case "InsertRowsNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertRowsNode((InsertRowsNode)insertNode);
                }
                case "InsertRowsOfOneDeviceNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertRowsOfOneDeviceNode((InsertRowsOfOneDeviceNode)insertNode);
                }
                case "InsertMultiTabletsNode": {
                    return InsertNodeMemoryEstimator.sizeOfInsertMultiTabletsNode((InsertMultiTabletsNode)insertNode);
                }
                case "RelationalInsertRowsNode": {
                    return InsertNodeMemoryEstimator.sizeOfRelationalInsertRowsNode((RelationalInsertRowsNode)insertNode);
                }
                case "RelationalInsertRowNode": {
                    return InsertNodeMemoryEstimator.sizeOfRelationalInsertRowNode((RelationalInsertRowNode)insertNode);
                }
                case "RelationalInsertTabletNode": {
                    return InsertNodeMemoryEstimator.sizeOfRelationalInsertTabletNode((RelationalInsertTabletNode)insertNode);
                }
            }
            return 0L;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to estimate size for InsertNode: {}", (Object)e.getMessage(), (Object)e);
            return 0L;
        }
    }

    private static long calculateFullInsertNodeSize(InsertNode node) {
        long size = 0L;
        size += InsertNodeMemoryEstimator.sizeOfPartialPath(node.getTargetPath());
        size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(node.getMeasurementSchemas());
        size += InsertNodeMemoryEstimator.sizeOfStringArray(node.getMeasurements());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getDataTypes());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getColumnCategories());
        size += InsertNodeMemoryEstimator.sizeOfColumnIndices(node.getColumnCategories());
        if (node.isDeviceIDExists()) {
            size += InsertNodeMemoryEstimator.sizeOfIDeviceID(node.getDeviceID());
        }
        size += InsertNodeMemoryEstimator.sizeOfTRegionReplicaSet(node.getRegionReplicaSet());
        return size += InsertNodeMemoryEstimator.sizeOfProgressIndex(node.getProgressIndex());
    }

    private static long calculateInsertNodeSizeExcludingSchemas(InsertNode node) {
        long size = 2L * RamUsageEstimator.shallowSizeOf((Object[])node.getMeasurementSchemas());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getDataTypes());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getColumnCategories());
        size += InsertNodeMemoryEstimator.sizeOfColumnIndices(node.getColumnCategories());
        if (node.isDeviceIDExists()) {
            size += InsertNodeMemoryEstimator.sizeOfIDeviceID(node.getDeviceID());
        }
        size += InsertNodeMemoryEstimator.sizeOfTRegionReplicaSet(node.getRegionReplicaSet());
        return size += InsertNodeMemoryEstimator.sizeOfProgressIndex(node.getProgressIndex());
    }

    private static long sizeOfInsertTabletNode(InsertTabletNode node) {
        long size = INSERT_TABLET_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        size += RamUsageEstimator.sizeOf((long[])node.getTimes());
        size += InsertNodeMemoryEstimator.sizeOfBitMapArray(node.getBitMaps());
        size += InsertNodeMemoryEstimator.sizeOfColumns(node.getColumns(), node.getMeasurementSchemas());
        List<Integer> range = node.getRange();
        if (range != null) {
            size += NUM_BYTES_OBJECT_HEADER + SIZE_OF_INT * (long)range.size();
        }
        return size;
    }

    private static long calculateInsertTabletNodeSizeExcludingSchemas(InsertTabletNode node) {
        long size = INSERT_TABLET_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateInsertNodeSizeExcludingSchemas(node);
        size += RamUsageEstimator.sizeOf((long[])node.getTimes());
        size += InsertNodeMemoryEstimator.sizeOfBitMapArray(node.getBitMaps());
        size += InsertNodeMemoryEstimator.sizeOfColumns(node.getColumns(), node.getMeasurementSchemas());
        List<Integer> range = node.getRange();
        if (range != null) {
            size += NUM_BYTES_OBJECT_HEADER + SIZE_OF_INT * (long)range.size();
        }
        return size;
    }

    private static long sizeOfInsertRowNode(InsertRowNode node) {
        long size = INSERT_ROW_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        return size += InsertNodeMemoryEstimator.sizeOfValues(node.getValues(), node.getMeasurementSchemas());
    }

    private static long calculateInsertRowNodeExcludingSchemas(InsertRowNode node) {
        long size = INSERT_ROW_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateInsertNodeSizeExcludingSchemas(node);
        return size += InsertNodeMemoryEstimator.sizeOfValues(node.getValues(), node.getMeasurementSchemas());
    }

    private static long sizeOfInsertRowsNode(InsertRowsNode node) {
        long size = INSERT_ROWS_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        List<InsertRowNode> rows = node.getInsertRowNodeList();
        List<Integer> indexList = node.getInsertRowNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertRowNodeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getTargetPath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        return size;
    }

    private static long sizeOfInsertRowsOfOneDeviceNode(InsertRowsOfOneDeviceNode node) {
        long size = INSERT_ROWS_OF_ONE_DEVICE_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        List<InsertRowNode> rows = node.getInsertRowNodeList();
        List<Integer> indexList = node.getInsertRowNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertRowNodeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getTargetPath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        size += NUM_BYTES_OBJECT_HEADER;
        for (Map.Entry<Integer, TSStatus> entry : node.getResults().entrySet()) {
            size += 4L + InsertNodeMemoryEstimator.sizeOfTSStatus(entry.getValue()) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
        }
        return size;
    }

    private static long sizeOfInsertMultiTabletsNode(InsertMultiTabletsNode node) {
        long size = INSERT_MULTI_TABLETS_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getDataTypes());
        size += RamUsageEstimator.shallowSizeOf((Object[])node.getColumnCategories());
        List<InsertTabletNode> rows = node.getInsertTabletNodeList();
        List<Integer> indexList = node.getParentInsertTabletNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertTabletNodeSizeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getTargetPath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        if (node.getResults() != null) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (Map.Entry<Integer, TSStatus> entry : node.getResults().entrySet()) {
                size += 4L + InsertNodeMemoryEstimator.sizeOfTSStatus(entry.getValue()) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
        }
        return size;
    }

    private static long sizeOfRelationalInsertRowsNode(RelationalInsertRowsNode node) {
        long size = RELATIONAL_INSERT_ROWS_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        List<InsertRowNode> rows = node.getInsertRowNodeList();
        List<Integer> indexList = node.getInsertRowNodeIndexList();
        if (rows != null && !rows.isEmpty()) {
            size += NUM_BYTES_OBJECT_HEADER;
            size += (InsertNodeMemoryEstimator.calculateInsertRowNodeExcludingSchemas(rows.get(0)) + NUM_BYTES_OBJECT_REF) * (long)rows.size();
            size += InsertNodeMemoryEstimator.sizeOfPartialPath(rows.get(0).getTargetPath());
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchemas(rows.get(0).getMeasurementSchemas());
            size += NUM_BYTES_OBJECT_HEADER;
            size += (long)indexList.size() * (SIZE_OF_INT + NUM_BYTES_OBJECT_REF);
        }
        return size;
    }

    private static long sizeOfRelationalInsertRowNode(RelationalInsertRowNode node) {
        long size = RELATIONAL_INSERT_ROW_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        return size += InsertNodeMemoryEstimator.sizeOfValues(node.getValues(), node.getMeasurementSchemas());
    }

    private static long sizeOfRelationalInsertTabletNode(RelationalInsertTabletNode node) {
        long size = RELATIONAL_INSERT_TABLET_NODE_SIZE;
        size += InsertNodeMemoryEstimator.calculateFullInsertNodeSize(node);
        size += RamUsageEstimator.sizeOf((long[])node.getTimes());
        size += InsertNodeMemoryEstimator.sizeOfBitMapArray(node.getBitMaps());
        size += InsertNodeMemoryEstimator.sizeOfColumns(node.getColumns(), node.getMeasurementSchemas());
        List<Integer> range = node.getRange();
        if (range != null) {
            size += NUM_BYTES_OBJECT_HEADER + (NUM_BYTES_OBJECT_REF + 4L) * (long)range.size();
        }
        return size;
    }

    public static long sizeOfPartialPath(PartialPath partialPath) {
        if (partialPath == null) {
            return 0L;
        }
        long size = PARTIAL_PATH_SIZE;
        String[] nodes = partialPath.getNodes();
        if (nodes != null) {
            size += InsertNodeMemoryEstimator.sizeOfStringArray(nodes) * 2L;
            size += (long)(".".length() * (nodes.length - 1)) + NUM_BYTES_OBJECT_HEADER;
        }
        return size;
    }

    public static long sizeOfMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        if (measurementSchemas == null) {
            return 0L;
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)measurementSchemas.length));
        for (MeasurementSchema measurementSchema : measurementSchemas) {
            size += InsertNodeMemoryEstimator.sizeOfMeasurementSchema(measurementSchema);
        }
        return size;
    }

    public static long sizeOfMeasurementSchema(MeasurementSchema measurementSchema) {
        if (measurementSchema == null) {
            return 0L;
        }
        long size = MEASUREMENT_SCHEMA_SIZE;
        size += RamUsageEstimator.sizeOf((String)measurementSchema.getMeasurementName());
        Map props = measurementSchema.getProps();
        if (props != null) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (Map.Entry entry : props.entrySet()) {
                size += RamUsageEstimator.sizeOf((String)((String)entry.getKey())) + RamUsageEstimator.sizeOf((String)((String)entry.getValue())) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            }
        }
        return size += TS_ENCODING_PLAIN_BUILDER_SIZE;
    }

    private static long sizeOfColumnIndices(TsTableColumnCategory[] columnCategories) {
        if (columnCategories == null) {
            return 0L;
        }
        long size = SIZE_OF_ARRAYLIST;
        size += NUM_BYTES_ARRAY_HEADER;
        for (TsTableColumnCategory columnCategory : columnCategories) {
            if (columnCategory == null || !columnCategory.equals((Object)TsTableColumnCategory.TAG)) continue;
            size += SIZE_OF_INT + NUM_BYTES_OBJECT_REF;
        }
        return size;
    }

    public static long sizeOfIDeviceID(IDeviceID deviceID) {
        return Objects.nonNull(deviceID) ? deviceID.ramBytesUsed() : 0L;
    }

    private static long sizeOfTRegionReplicaSet(TRegionReplicaSet tRegionReplicaSet) {
        if (tRegionReplicaSet == null) {
            return 0L;
        }
        long size = T_REGION_REPLICA_SET_SIZE;
        if (tRegionReplicaSet.isSetRegionId()) {
            size += InsertNodeMemoryEstimator.sizeOfTConsensusGroupId();
        }
        if (tRegionReplicaSet.isSetDataNodeLocations()) {
            size += NUM_BYTES_OBJECT_HEADER;
            for (TDataNodeLocation tDataNodeLocation : tRegionReplicaSet.getDataNodeLocations()) {
                size += InsertNodeMemoryEstimator.sizeOfTDataNodeLocation(tDataNodeLocation);
            }
        }
        return size;
    }

    private static long sizeOfTConsensusGroupId() {
        return T_CONSENSUS_GROUP_ID_SIZE;
    }

    private static long sizeOfTDataNodeLocation(TDataNodeLocation tDataNodeLocation) {
        if (tDataNodeLocation == null) {
            return 0L;
        }
        long size = T_DATA_NODE_LOCATION_SIZE;
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getClientRpcEndPoint());
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getInternalEndPoint());
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getMPPDataExchangeEndPoint());
        size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getDataRegionConsensusEndPoint());
        return size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tDataNodeLocation.getSchemaRegionConsensusEndPoint());
    }

    private static long sizeOfTEndPoint(TEndPoint tEndPoint) {
        if (tEndPoint == null) {
            return 0L;
        }
        long size = T_END_POINT_SIZE;
        return size += RamUsageEstimator.sizeOf((String)tEndPoint.ip);
    }

    private static long sizeOfTSStatus(TSStatus tSStatus) {
        if (tSStatus == null) {
            return 0L;
        }
        long size = TS_STATUS_SIZE;
        if (tSStatus.isSetMessage()) {
            size += RamUsageEstimator.sizeOf((String)tSStatus.message);
        }
        if (tSStatus.isSetRedirectNode()) {
            size += InsertNodeMemoryEstimator.sizeOfTEndPoint(tSStatus.redirectNode);
        }
        return size;
    }

    private static long sizeOfProgressIndex(ProgressIndex progressIndex) {
        return Objects.nonNull(progressIndex) ? progressIndex.ramBytesUsed() : 0L;
    }

    private static long sizeOfBinary(Binary binary) {
        return Objects.nonNull(binary) ? binary.ramBytesUsed() : 0L;
    }

    public static long sizeOfStringArray(String[] values) {
        return Objects.nonNull(values) ? RamUsageEstimator.sizeOf((String[])values) : 0L;
    }

    public static long sizeOfBitMapArray(BitMap[] bitMaps) {
        if (bitMaps == null) {
            return 0L;
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)bitMaps.length));
        for (BitMap bitMap : bitMaps) {
            size += InsertNodeMemoryEstimator.sizeOfBitMap(bitMap);
        }
        return size;
    }

    private static long sizeOfBitMap(BitMap bitMaps) {
        if (bitMaps == null) {
            return 0L;
        }
        long size = BIT_MAP_SIZE;
        return size += RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + (long)bitMaps.getByteArray().length));
    }

    public static long sizeOfColumns(Object[] columns, MeasurementSchema[] measurementSchemas) {
        if (Objects.isNull(measurementSchemas)) {
            return RamUsageEstimator.shallowSizeOf((Object[])columns) + Arrays.stream(columns).mapToLong(InsertNodeMemoryEstimator::getNumBytesUnknownObject).reduce(0L, Long::sum);
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)columns.length));
        block8: for (int i = 0; i < columns.length; ++i) {
            if (measurementSchemas[i] == null || measurementSchemas[i].getType() == null) continue;
            switch (measurementSchemas[i].getType()) {
                case INT64: 
                case TIMESTAMP: {
                    size += RamUsageEstimator.sizeOf((long[])((long[])columns[i]));
                    continue block8;
                }
                case DATE: 
                case INT32: {
                    size += RamUsageEstimator.sizeOf((int[])((int[])columns[i]));
                    continue block8;
                }
                case DOUBLE: {
                    size += RamUsageEstimator.sizeOf((double[])((double[])columns[i]));
                    continue block8;
                }
                case FLOAT: {
                    size += RamUsageEstimator.sizeOf((float[])((float[])columns[i]));
                    continue block8;
                }
                case BOOLEAN: {
                    size += RamUsageEstimator.sizeOf((boolean[])((boolean[])columns[i]));
                    continue block8;
                }
                case STRING: 
                case TEXT: 
                case BLOB: {
                    size += InsertNodeMemoryEstimator.getBinarySize((Binary[])columns[i]);
                }
            }
        }
        return size;
    }

    private static long getNumBytesUnknownObject(Object obj) {
        return obj instanceof Binary[] ? InsertNodeMemoryEstimator.getBinarySize((Binary[])obj) : RamUsageEstimator.sizeOfObject((Object)obj);
    }

    private static long getBinarySize(Binary[] binaries) {
        if (binaries == null) {
            return 0L;
        }
        return RamUsageEstimator.shallowSizeOf((Object[])binaries) + Arrays.stream(binaries).mapToLong(InsertNodeMemoryEstimator::sizeOfBinary).reduce(0L, Long::sum);
    }

    public static long sizeOfValues(Object[] values, MeasurementSchema[] measurementSchemas) {
        if (Objects.isNull(measurementSchemas)) {
            return RamUsageEstimator.shallowSizeOf((Object[])values) + Arrays.stream(values).mapToLong(InsertNodeMemoryEstimator::getNumBytesUnknownObject).reduce(0L, Long::sum);
        }
        long size = RamUsageEstimator.alignObjectSize((long)(NUM_BYTES_ARRAY_HEADER + NUM_BYTES_OBJECT_REF * (long)values.length));
        block8: for (int i = 0; i < values.length; ++i) {
            if (measurementSchemas[i] == null || measurementSchemas[i].getType() == null) {
                size += NUM_BYTES_OBJECT_HEADER;
                continue;
            }
            switch (measurementSchemas[i].getType()) {
                case INT64: 
                case TIMESTAMP: {
                    size += SIZE_OF_LONG;
                    continue block8;
                }
                case DATE: 
                case INT32: {
                    size += SIZE_OF_INT;
                    continue block8;
                }
                case DOUBLE: {
                    size += SIZE_OF_DOUBLE;
                    continue block8;
                }
                case FLOAT: {
                    size += SIZE_OF_FLOAT;
                    continue block8;
                }
                case BOOLEAN: {
                    size += SIZE_OF_BOOLEAN;
                    continue block8;
                }
                case STRING: 
                case TEXT: 
                case BLOB: {
                    Binary binary = (Binary)values[i];
                    size += InsertNodeMemoryEstimator.sizeOfBinary(binary);
                }
            }
        }
        return size;
    }
}

