/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternUtil;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncrypt;
import org.apache.iotdb.commons.security.encrypt.AsymmetricEncryptFactory;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtils.class);
    private static final String ROOT_PREFIX = "root";
    private static final int MIN_LENGTH = 4;
    private static final int MAX_LENGTH = 32;
    private static final String REX_PATTERN = "^[-\\w!@#$%^&*()+=]*$";

    private AuthUtils() {
    }

    public static void validatePassword(String password) throws AuthException {
        AuthUtils.validateNameOrPassword(password);
    }

    public static boolean validatePassword(String originPassword, String encryptPassword) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).validate(originPassword, encryptPassword, AsymmetricEncrypt.DigestAlgorithm.SHA_256);
    }

    public static boolean validatePassword(String originPassword, String encryptPassword, AsymmetricEncrypt.DigestAlgorithm digestAlgorithm) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).validate(originPassword, encryptPassword, digestAlgorithm);
    }

    public static void validateUsername(String username) throws AuthException {
        AuthUtils.validateNameOrPassword(username);
    }

    public static void validateRolename(String roleName) throws AuthException {
        AuthUtils.validateNameOrPassword(roleName);
    }

    public static void validateNameOrPassword(String str) throws AuthException {
        int length = str.length();
        if (length < 4) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The length of name or password must be greater than or equal to 4");
        }
        if (length > 32) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The length of name or password must be less than or equal to 32");
        }
        if (str.contains(" ")) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The name or password cannot contain spaces");
        }
        if (!str.matches(REX_PATTERN)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "The name or password can only contain letters, numbers or !@#$%^*()_+-=");
        }
    }

    public static void validatePath(PartialPath path) throws AuthException {
        if (!path.getFirstNode().equals(ROOT_PREFIX)) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal seriesPath %s, seriesPath should start with \"%s\"", path, ROOT_PREFIX));
        }
    }

    public static void validatePatternPath(PartialPath path) throws AuthException {
        AuthUtils.validatePath(path);
        if (!path.hasWildcard()) {
            return;
        }
        if (!PathPatternUtil.isMultiLevelMatchWildcard(path.getTailNode())) {
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal pattern path: %s, only pattern path that end with ** are supported.", path));
        }
        for (int i = 0; i < path.getNodeLength() - 1; ++i) {
            if (!PathPatternUtil.hasWildcard(path.getNodes()[i])) continue;
            throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, String.format("Illegal pattern path: %s, only pattern path that end with wildcards are supported.", path));
        }
    }

    public static String encryptPassword(String password) {
        return AsymmetricEncryptFactory.getEncryptProvider(CommonDescriptor.getInstance().getConfig().getEncryptDecryptProvider(), CommonDescriptor.getInstance().getConfig().getEncryptDecryptProviderParameter()).encrypt(password, AsymmetricEncrypt.DigestAlgorithm.SHA_256);
    }

    public static boolean checkPathPrivilege(PartialPath path, PrivilegeType priv, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().matchFullPath(path) || !pathPrivilege.checkPrivilege(priv)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkPathPrivilegeGrantOpt(PartialPath path, PrivilegeType priv, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return false;
        }
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().matchFullPath(path) || !pathPrivilege.getPrivileges().contains((Object)priv) || !pathPrivilege.getGrantOpt().contains((Object)priv)) continue;
            return true;
        }
        return false;
    }

    public static Set<PrivilegeType> getPrivileges(PartialPath path, List<PathPrivilege> privilegeList) {
        if (privilegeList == null) {
            return new HashSet<PrivilegeType>();
        }
        HashSet<PrivilegeType> privileges = new HashSet<PrivilegeType>();
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().matchFullPath(path)) continue;
            for (Integer item : pathPrivilege.getPrivilegeIntSet()) {
                privileges.add(PrivilegeType.values()[item]);
            }
        }
        return privileges;
    }

    public static boolean hasPrivilegeToRevoke(PartialPath path, PrivilegeType priv, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!path.matchFullPath(pathPrivilege.getPath()) || !pathPrivilege.getPrivileges().contains((Object)priv)) continue;
            return true;
        }
        return false;
    }

    public static void addPrivilege(PartialPath path, PrivilegeType priv, List<PathPrivilege> privilegeList, boolean grantOption) {
        PathPrivilege targetPathPrivilege = null;
        for (PathPrivilege pathPrivilege : privilegeList) {
            if (!pathPrivilege.getPath().equals(path)) continue;
            targetPathPrivilege = pathPrivilege;
            break;
        }
        if (targetPathPrivilege == null) {
            targetPathPrivilege = new PathPrivilege(path);
            privilegeList.add(targetPathPrivilege);
        }
        targetPathPrivilege.grantPrivilege(priv, grantOption);
    }

    public static void removePrivilege(PartialPath path, PrivilegeType priv, List<PathPrivilege> privilegeList) {
        Iterator<PathPrivilege> it = privilegeList.iterator();
        while (it.hasNext()) {
            PathPrivilege pathPri = it.next();
            if (!path.matchFullPath(pathPri.getPath())) continue;
            pathPri.revokePrivilege(priv);
            if (!pathPri.getPrivilegeIntSet().isEmpty()) continue;
            it.remove();
        }
    }

    public static void removePrivilegeGrantOption(PartialPath path, PrivilegeType priv, List<PathPrivilege> privilegeList) {
        for (PathPrivilege pathPri : privilegeList) {
            if (!path.matchFullPath(pathPri.getPath())) continue;
            pathPri.revokeGrantOpt(priv);
        }
    }

    public static TPermissionInfoResp generateEmptyPermissionInfoResp() {
        TPermissionInfoResp permissionInfoResp = new TPermissionInfoResp();
        permissionInfoResp.setUserInfo(new TUserResp(new TRoleResp("", new ArrayList(), new HashSet(), new HashSet(), new HashMap(), new HashSet(), new HashSet()), "", new HashSet(), false));
        HashMap<String, TRoleResp> roleInfo = new HashMap<String, TRoleResp>();
        roleInfo.put("", new TRoleResp("", new ArrayList(), new HashSet(), new HashSet(), new HashMap(), new HashSet(), new HashSet()));
        permissionInfoResp.setRoleInfo(roleInfo);
        return permissionInfoResp;
    }

    public static Set<Integer> strToPermissions(String[] authorizationList) throws AuthException {
        HashSet<Integer> result = new HashSet<Integer>();
        if (authorizationList == null) {
            return result;
        }
        PrivilegeType[] types = PrivilegeType.values();
        for (String authorization : authorizationList) {
            boolean legal = false;
            for (PrivilegeType privilegeType : types) {
                if (!authorization.equalsIgnoreCase(privilegeType.name())) continue;
                result.add(privilegeType.ordinal());
                legal = true;
                break;
            }
            if (legal) continue;
            throw new AuthException(TSStatusCode.UNKNOWN_AUTH_PRIVILEGE, "No such privilege " + authorization);
        }
        return result;
    }

    public static ByteBuffer serializePartialPathList(List<? extends PartialPath> paths) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(paths.size());
            for (PartialPath partialPath : paths) {
                partialPath.serialize(dataOutputStream);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to serialize PartialPath list", (Throwable)e);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public static List<PartialPath> deserializePartialPathList(ByteBuffer buffer) {
        int size = buffer.getInt();
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (int i = 0; i < size; ++i) {
            paths.add((PartialPath)PathDeserializeUtil.deserialize(buffer));
        }
        return paths;
    }

    public static PrivilegeType posToSysPri(int pos) {
        switch (pos) {
            case 0: {
                return PrivilegeType.MANAGE_DATABASE;
            }
            case 1: {
                return PrivilegeType.MANAGE_USER;
            }
            case 2: {
                return PrivilegeType.MANAGE_ROLE;
            }
            case 3: {
                return PrivilegeType.USE_TRIGGER;
            }
            case 4: {
                return PrivilegeType.USE_UDF;
            }
            case 5: {
                return PrivilegeType.USE_CQ;
            }
            case 6: {
                return PrivilegeType.USE_PIPE;
            }
            case 7: {
                return PrivilegeType.EXTEND_TEMPLATE;
            }
            case 8: {
                return PrivilegeType.MAINTAIN;
            }
            case 9: {
                return PrivilegeType.USE_MODEL;
            }
        }
        LOGGER.warn("Not support position");
        throw new RuntimeException("Not support position");
    }

    public static int sysPriToPos(PrivilegeType priv) {
        switch (priv) {
            case MANAGE_DATABASE: {
                return 0;
            }
            case MANAGE_USER: {
                return 1;
            }
            case MANAGE_ROLE: {
                return 2;
            }
            case USE_TRIGGER: {
                return 3;
            }
            case USE_UDF: {
                return 4;
            }
            case USE_CQ: {
                return 5;
            }
            case USE_PIPE: {
                return 6;
            }
            case EXTEND_TEMPLATE: {
                return 7;
            }
            case MAINTAIN: {
                return 8;
            }
            case USE_MODEL: {
                return 9;
            }
        }
        return -1;
    }

    public static int pathPosToPri(int pos) {
        switch (pos) {
            case 0: {
                return PrivilegeType.READ_DATA.ordinal();
            }
            case 1: {
                return PrivilegeType.WRITE_DATA.ordinal();
            }
            case 2: {
                return PrivilegeType.READ_SCHEMA.ordinal();
            }
            case 3: {
                return PrivilegeType.WRITE_SCHEMA.ordinal();
            }
        }
        return -1;
    }

    public static int pathPriToPos(PrivilegeType pri) {
        switch (pri) {
            case READ_DATA: {
                return 0;
            }
            case WRITE_DATA: {
                return 1;
            }
            case READ_SCHEMA: {
                return 2;
            }
            case WRITE_SCHEMA: {
                return 3;
            }
        }
        throw new RuntimeException("Not support PrivilegeType " + (Object)((Object)pri));
    }

    public static PrivilegeType posToObjPri(int pos) {
        switch (pos) {
            case 0: {
                return PrivilegeType.CREATE;
            }
            case 1: {
                return PrivilegeType.DROP;
            }
            case 2: {
                return PrivilegeType.ALTER;
            }
            case 3: {
                return PrivilegeType.SELECT;
            }
            case 4: {
                return PrivilegeType.INSERT;
            }
            case 5: {
                return PrivilegeType.DELETE;
            }
        }
        throw new RuntimeException("Not support position");
    }

    public static int objPriToPos(PrivilegeType pri) {
        switch (pri) {
            case CREATE: {
                return 0;
            }
            case DROP: {
                return 1;
            }
            case ALTER: {
                return 2;
            }
            case SELECT: {
                return 3;
            }
            case INSERT: {
                return 4;
            }
            case DELETE: {
                return 5;
            }
        }
        throw new RuntimeException("Not support position");
    }
}

