/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.raftlog.segmented;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Optional;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.server.metrics.SegmentedRaftLogMetrics;
import org.apache.ratis.server.raftlog.segmented.LogSegmentStartEnd;
import org.apache.ratis.server.raftlog.segmented.SegmentedRaftLogReader;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.OpenCloseState;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentedRaftLogInputStream
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(SegmentedRaftLogInputStream.class);
    private final File logFile;
    private final LogSegmentStartEnd startEnd;
    private final OpenCloseState state;
    private SegmentedRaftLogReader reader;
    private final SizeInBytes maxOpSize;
    private final SegmentedRaftLogMetrics raftLogMetrics;

    SegmentedRaftLogInputStream(File log, LogSegmentStartEnd startEnd, SizeInBytes maxOpSize, SegmentedRaftLogMetrics raftLogMetrics) {
        this.maxOpSize = maxOpSize;
        this.logFile = log;
        this.startEnd = startEnd;
        this.state = new OpenCloseState(this.getName());
        this.raftLogMetrics = raftLogMetrics;
    }

    private void init() throws IOException {
        this.state.open();
        boolean initSuccess = false;
        try {
            this.reader = new SegmentedRaftLogReader(this.logFile, this.maxOpSize, this.raftLogMetrics);
            initSuccess = this.reader.verifyHeader();
        }
        finally {
            if (!initSuccess) {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                this.state.close();
            }
        }
    }

    String getName() {
        return this.logFile.getName();
    }

    public RaftProtos.LogEntryProto nextEntry() throws IOException {
        if (this.state.isUnopened()) {
            try {
                this.init();
            }
            catch (Exception e) {
                if (e.getCause() instanceof ClosedByInterruptException) {
                    LOG.warn("Initialization is interrupted: {}", (Object)this, (Object)e);
                } else {
                    LOG.error("Failed to initialize {}", (Object)this, (Object)e);
                }
                throw IOUtils.asIOException((Throwable)e);
            }
        }
        Preconditions.assertTrue((!this.state.isUnopened() ? 1 : 0) != 0);
        if (this.state.isOpened()) {
            RaftProtos.LogEntryProto entry = this.reader.readEntry();
            if (entry != null) {
                long skipAmt;
                long index = entry.getIndex();
                if (!this.startEnd.isOpen() && index >= this.startEnd.getEndIndex() && (skipAmt = this.logFile.length() - this.reader.getPos()) > 0L) {
                    LOG.info("Skipping {} bytes at the end of log '{}': reached entry {} out of [{}]", new Object[]{skipAmt, this.getName(), index, this.startEnd});
                    this.reader.skipFully(skipAmt);
                }
            }
            return entry;
        }
        if (this.state.isClosed()) {
            return null;
        }
        throw new IOException("Failed to get next entry from " + this, this.state.getThrowable());
    }

    long scanNextEntry() throws IOException {
        this.state.assertOpen();
        return this.reader.scanEntry();
    }

    long getPosition() {
        if (this.state.isOpened()) {
            return this.reader.getPos();
        }
        return 0L;
    }

    @Override
    public void close() throws IOException {
        if (this.state.close()) {
            Optional.ofNullable(this.reader).ifPresent(SegmentedRaftLogReader::close);
        }
    }

    public String toString() {
        return this.getName();
    }

    static LogValidation scanEditLog(File file, long maxTxIdToScan, SizeInBytes maxOpSize) throws IOException {
        LogSegmentStartEnd startEnd = LogSegmentStartEnd.valueOf(0L);
        SegmentedRaftLogInputStream in = new SegmentedRaftLogInputStream(file, startEnd, maxOpSize, null);
        try {
            try {
                in.init();
            }
            catch (EOFException e) {
                LOG.warn("Invalid header for RaftLog segment {}", (Object)file, (Object)e);
                LogValidation logValidation = new LogValidation(0L, -1L, true);
                in.close();
                return logValidation;
            }
            LogValidation logValidation = SegmentedRaftLogInputStream.scanEditLog(in, maxTxIdToScan);
            return logValidation;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    static LogValidation scanEditLog(SegmentedRaftLogInputStream in, long maxIndexToScan) {
        long lastPos = 0L;
        long end = -1L;
        long numValid = 0L;
        boolean hitError = false;
        while (end < maxIndexToScan) {
            long index;
            lastPos = in.getPosition();
            try {
                if (hitError) {
                    RaftProtos.LogEntryProto entry = in.nextEntry();
                    index = entry != null ? entry.getIndex() : -1L;
                    LOG.warn("After resync, position is " + in.getPosition());
                } else {
                    index = in.scanNextEntry();
                }
                if (index == -1L) break;
                hitError = false;
            }
            catch (Exception e) {
                LOG.warn("Caught exception after scanning through {} ops from {} while determining its valid length. Position was " + lastPos, new Object[]{numValid, in, e});
                hitError = true;
                continue;
            }
            if (end == -1L || index > end) {
                end = index;
            }
            ++numValid;
        }
        return new LogValidation(lastPos, end, false);
    }

    static class LogValidation {
        private final long validLength;
        private final long endIndex;
        private final boolean hasCorruptHeader;

        LogValidation(long validLength, long endIndex, boolean hasCorruptHeader) {
            this.validLength = validLength;
            this.endIndex = endIndex;
            this.hasCorruptHeader = hasCorruptHeader;
        }

        long getValidLength() {
            return this.validLength;
        }

        long getEndIndex() {
            return this.endIndex;
        }

        boolean hasCorruptHeader() {
            return this.hasCorruptHeader;
        }
    }
}

