/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.filter.StatisticsClassException;
import org.apache.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FloatStatistics
extends Statistics<Float> {
    public static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FloatStatistics.class);
    private float minValue;
    private float maxValue;
    private float firstValue;
    private float lastValue;
    private double sumValue;

    @Override
    public TSDataType getType() {
        return TSDataType.FLOAT;
    }

    @Override
    public int getStatsSize() {
        return 24;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public void initializeStats(float min, float max, float first, float last, double sum) {
        this.minValue = min;
        this.maxValue = max;
        this.firstValue = first;
        this.lastValue = last;
        this.sumValue = sum;
    }

    private void updateStats(float minValue, float maxValue, float last, double sumValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        this.lastValue = last;
    }

    private void updateStats(float minValue, float maxValue, float first, float last, double sumValue, long startTime, long endTime) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
        this.sumValue += sumValue;
        if (startTime <= this.getStartTime()) {
            this.firstValue = first;
        }
        if (endTime >= this.getEndTime()) {
            this.lastValue = last;
        }
    }

    @Override
    void updateStats(float value) {
        if (this.isEmpty) {
            this.initializeStats(value, value, value, value, value);
            this.isEmpty = false;
        } else {
            this.updateStats(value, value, value, value);
        }
    }

    @Override
    void updateStats(float[] values, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            this.updateStats(values[i]);
        }
    }

    @Override
    public void updateStats(float minValue, float maxValue) {
        if (minValue < this.minValue) {
            this.minValue = minValue;
        }
        if (maxValue > this.maxValue) {
            this.maxValue = maxValue;
        }
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(this.minValue);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(this.maxValue);
    }

    @Override
    public Float getFirstValue() {
        return Float.valueOf(this.firstValue);
    }

    @Override
    public Float getLastValue() {
        return Float.valueOf(this.lastValue);
    }

    @Override
    public double getSumDoubleValue() {
        return this.sumValue;
    }

    @Override
    public long getSumLongValue() {
        throw new StatisticsClassException(String.format("%s statistics does not support: %s", new Object[]{TSDataType.FLOAT, "long sum"}));
    }

    @Override
    protected void mergeStatisticsValue(Statistics stats) {
        if (stats instanceof FloatStatistics || stats instanceof IntegerStatistics) {
            if (this.isEmpty) {
                this.initializeStats(((Number)stats.getMinValue()).floatValue(), ((Number)stats.getMaxValue()).floatValue(), ((Number)stats.getFirstValue()).floatValue(), ((Number)stats.getLastValue()).floatValue(), stats.getSumDoubleValue());
                this.isEmpty = false;
            } else {
                this.updateStats(((Number)stats.getMinValue()).floatValue(), ((Number)stats.getMaxValue()).floatValue(), ((Number)stats.getFirstValue()).floatValue(), ((Number)stats.getLastValue()).floatValue(), stats.getSumDoubleValue(), stats.getStartTime(), stats.getEndTime());
            }
        } else {
            throw new StatisticsClassException(this.getClass(), stats.getClass());
        }
    }

    @Override
    public int serializeStats(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.minValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.maxValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.firstValue, outputStream);
        byteLen += ReadWriteIOUtils.write(this.lastValue, outputStream);
        return byteLen += ReadWriteIOUtils.write(this.sumValue, outputStream);
    }

    @Override
    public void deserialize(InputStream inputStream) throws IOException {
        this.minValue = ReadWriteIOUtils.readFloat(inputStream);
        this.maxValue = ReadWriteIOUtils.readFloat(inputStream);
        this.firstValue = ReadWriteIOUtils.readFloat(inputStream);
        this.lastValue = ReadWriteIOUtils.readFloat(inputStream);
        this.sumValue = ReadWriteIOUtils.readDouble(inputStream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        this.minValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.maxValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.firstValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.lastValue = ReadWriteIOUtils.readFloat(byteBuffer);
        this.sumValue = ReadWriteIOUtils.readDouble(byteBuffer);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        double e = 1.0E-5;
        FloatStatistics that = (FloatStatistics)o;
        return (double)Math.abs(that.minValue - this.minValue) < e && (double)Math.abs(that.maxValue - this.maxValue) < e && (double)Math.abs(that.firstValue - this.firstValue) < e && (double)Math.abs(that.lastValue - this.lastValue) < e && Math.abs(that.sumValue - this.sumValue) < e;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.minValue), Float.valueOf(this.maxValue), Float.valueOf(this.firstValue), Float.valueOf(this.lastValue), this.sumValue);
    }

    @Override
    public String toString() {
        return super.toString() + " [minValue:" + this.minValue + ",maxValue:" + this.maxValue + ",firstValue:" + this.firstValue + ",lastValue:" + this.lastValue + ",sumValue:" + this.sumValue + "]";
    }
}

