/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;

public class ConcatColumnTransformer
extends UnaryColumnTransformer {
    private final byte[] value;
    private final boolean isBehind;

    public ConcatColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, String valueStr, boolean isBehind) {
        super(returnType, childColumnTransformer);
        this.value = valueStr.getBytes();
        this.isBehind = isBehind;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            this.transform(column, columnBuilder, i);
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i]) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    private void transform(Column column, ColumnBuilder columnBuilder, int i) {
        if (!column.isNull(i)) {
            if (this.isBehind) {
                columnBuilder.writeBinary(new Binary(ConcatColumnTransformer.concat(column.getBinary(i).getValues(), this.value)));
            } else {
                columnBuilder.writeBinary(new Binary(ConcatColumnTransformer.concat(this.value, column.getBinary(i).getValues())));
            }
        } else {
            columnBuilder.writeBinary(new Binary(this.value));
        }
    }

    public static byte[] concat(byte[] leftValue, byte[] rightValue) {
        byte[] result = new byte[leftValue.length + rightValue.length];
        System.arraycopy(leftValue, 0, result, 0, leftValue.length);
        System.arraycopy(rightValue, 0, result, leftValue.length, rightValue.length);
        return result;
    }
}

