/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class FindServersResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=423");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=425");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=424");
    private final ResponseHeader responseHeader;
    private final ApplicationDescription[] servers;

    public FindServersResponse(ResponseHeader responseHeader, ApplicationDescription[] servers) {
        this.responseHeader = responseHeader;
        this.servers = servers;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public ApplicationDescription[] getServers() {
        return this.servers;
    }

    protected FindServersResponse(FindServersResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((FindServersResponseBuilder)b).responseHeader;
        this.servers = ((FindServersResponseBuilder)b).servers;
    }

    public static FindServersResponseBuilder<?, ?> builder() {
        return new FindServersResponseBuilderImpl();
    }

    public FindServersResponseBuilder<?, ?> toBuilder() {
        return new FindServersResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServersResponse)) {
            return false;
        }
        FindServersResponse other = (FindServersResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        return Arrays.deepEquals(this.getServers(), other.getServers());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindServersResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServers());
        return result;
    }

    @Override
    public String toString() {
        return "FindServersResponse(responseHeader=" + this.getResponseHeader() + ", servers=" + Arrays.deepToString(this.getServers()) + ")";
    }

    private static final class FindServersResponseBuilderImpl
    extends FindServersResponseBuilder<FindServersResponse, FindServersResponseBuilderImpl> {
        private FindServersResponseBuilderImpl() {
        }

        @Override
        protected FindServersResponseBuilderImpl self() {
            return this;
        }

        @Override
        public FindServersResponse build() {
            return new FindServersResponse(this);
        }
    }

    public static abstract class FindServersResponseBuilder<C extends FindServersResponse, B extends FindServersResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private ApplicationDescription[] servers;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FindServersResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FindServersResponse instance, FindServersResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.servers(instance.servers);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B servers(ApplicationDescription[] servers) {
            this.servers = servers;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FindServersResponse.FindServersResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", servers=" + Arrays.deepToString(this.servers) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<FindServersResponse> {
        @Override
        public Class<FindServersResponse> getType() {
            return FindServersResponse.class;
        }

        @Override
        public FindServersResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            ApplicationDescription[] servers = (ApplicationDescription[])decoder.readStructArray("Servers", ApplicationDescription.TYPE_ID);
            return new FindServersResponse(responseHeader, servers);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, FindServersResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("Servers", (Object[])value.getServers(), ApplicationDescription.TYPE_ID);
        }
    }
}

