/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.IEntityAccessor;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.role.BasicRoleManager;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUserManager
extends BasicRoleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicUserManager.class);
    protected long nextUserId = 9999L;

    @Override
    protected TSStatusCode getEntityNotExistErrorCode() {
        return TSStatusCode.USER_NOT_EXIST;
    }

    @Override
    protected String getNoSuchEntityError() {
        return "No such user %s";
    }

    protected BasicUserManager(IEntityAccessor accessor) throws AuthException {
        super(accessor);
        this.accessor = accessor;
        this.init();
    }

    private void initAdmin() throws AuthException {
        User admin = this.getEntity(CommonDescriptor.getInstance().getConfig().getAdminName());
        if (admin == null) {
            this.createUser(CommonDescriptor.getInstance().getConfig().getAdminName(), CommonDescriptor.getInstance().getConfig().getAdminPassword(), true, true);
        }
        admin = this.getEntity(CommonDescriptor.getInstance().getConfig().getAdminName());
        try {
            PartialPath rootPath = new PartialPath("root.**");
            PathPrivilege pathPri = new PathPrivilege(rootPath);
            for (PrivilegeType item : PrivilegeType.values()) {
                if (item.isSystemPrivilege()) {
                    admin.grantSysPrivilege(item, true);
                    continue;
                }
                if (item.isRelationalPrivilege()) {
                    admin.grantAnyScopePrivilege(item, true);
                    continue;
                }
                if (!item.isPathPrivilege()) continue;
                pathPri.grantPrivilege(item, true);
            }
            admin.getPathPrivilegeList().clear();
            admin.getPathPrivilegeList().add(pathPri);
        }
        catch (IllegalPathException e) {
            LOGGER.warn("Got a wrong path for root to init");
        }
        LOGGER.info("Admin initialized");
    }

    private void initUserId() {
        try {
            long maxUserId = this.accessor.loadUserId();
            this.nextUserId = Math.max(maxUserId, 9999L);
            for (Map.Entry userEntry : this.entityMap.entrySet()) {
                User user = (User)userEntry.getValue();
                if (user.getUserId() != -1L) continue;
                user.setUserId(++this.nextUserId);
            }
        }
        catch (IOException e) {
            LOGGER.warn("meet error in load max userId.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public User getEntity(String entityName) {
        return (User)super.getEntity(entityName);
    }

    @Override
    public User getEntity(long entityId) {
        for (Map.Entry roleEntry : this.entityMap.entrySet()) {
            if (((User)roleEntry.getValue()).getUserId() != entityId) continue;
            return (User)roleEntry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String username, String password, boolean validCheck, boolean enableEncrypt) throws AuthException {
        User user;
        if (validCheck && !CommonDescriptor.getInstance().getConfig().getAdminName().equals(username)) {
            if (username.equals(password) && CommonDescriptor.getInstance().getConfig().isEnforceStrongPassword()) {
                throw new AuthException(TSStatusCode.ILLEGAL_PASSWORD, "Password cannot be the same as user name");
            }
            AuthUtils.validateUsername(username);
            if (enableEncrypt) {
                AuthUtils.validatePassword(password);
            }
        }
        if ((user = this.getEntity(username)) != null) {
            return false;
        }
        this.lock.writeLock(username);
        try {
            long userid = username.equals(CommonDescriptor.getInstance().getConfig().getAdminName()) ? 0L : ++this.nextUserId;
            user = new User(username, enableEncrypt ? AuthUtils.encryptPassword(password) : password, userid);
            this.entityMap.put(username, user);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserPassword(String username, String newPassword, boolean bypassValidate) throws AuthException {
        if (!bypassValidate) {
            if (CommonDescriptor.getInstance().getConfig().isEnforceStrongPassword() && username.equals(newPassword)) {
                throw new AuthException(TSStatusCode.ILLEGAL_PASSWORD, "Password cannot be the same as user name");
            }
            AuthUtils.validatePassword(newPassword);
        }
        this.lock.writeLock(username);
        try {
            User user = this.getEntity(username);
            if (user == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), username));
            }
            user.setPassword(AuthUtils.encryptPassword(newPassword));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantRoleToUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getEntity(username);
            if (user == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), username));
            }
            user.getRoleSet().add(roleName);
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeRoleFromUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getEntity(username);
            if (user == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), username));
            }
            user.getRoleSet().remove(roleName);
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    private void init() throws AuthException {
        this.accessor.reset();
        this.initAdmin();
    }

    @Override
    public void reset() throws AuthException {
        this.accessor.reset();
        this.entityMap.clear();
        this.initUserId();
        for (String userId : this.accessor.listAllEntities()) {
            try {
                User user = (User)this.accessor.loadEntity(userId);
                if (user.getUserId() == -1L) {
                    if (user.getName().equals(CommonDescriptor.getInstance().getConfig().getAdminName())) {
                        user.setUserId(0L);
                    } else {
                        user.setUserId(++this.nextUserId);
                    }
                }
                this.entityMap.put(user.getName(), user);
            }
            catch (IOException e) {
                LOGGER.warn("Get exception when load user {}", (Object)userId);
                throw new AuthException(TSStatusCode.AUTH_IO_EXCEPTION, (Throwable)e);
            }
        }
        this.initAdmin();
    }

    @TestOnly
    public boolean createUser(String username, String password, boolean validCheck) throws AuthException {
        return this.createUser(username, password, validCheck, true);
    }
}

