/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.protocol.client.DataNodeInternalClient;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractIntoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.InsertTabletStatementGenerator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TableInsertTabletStatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TableIntoOperator
extends AbstractIntoOperator {
    private final InsertTabletStatementGenerator insertTabletStatementGenerator;
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TableIntoOperator.class);
    private static final List<TSDataType> outputDataTypes = ColumnHeaderConstant.selectIntoTableColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    private static final long MAX_RETURN_SIZE = TableIntoOperator.getResultTsBlockSize();

    public TableIntoOperator(OperatorContext operatorContext, Operator child, String databaseName, PartialPath targetTable, List<TSDataType> inputColumnTypes, List<TsTableColumnCategory> inputColumnCategories, Map<String, InputLocation> measurementToInputLocationMap, Map<String, TSDataType> measurementToDataTypeMap, boolean isAligned, ExecutorService intoOperationExecutor, long statementSizePerLine) {
        super(operatorContext, child, inputColumnTypes, intoOperationExecutor, statementSizePerLine);
        this.maxReturnSize = MAX_RETURN_SIZE;
        this.insertTabletStatementGenerator = new TableInsertTabletStatementGenerator(databaseName, targetTable, measurementToInputLocationMap, measurementToDataTypeMap, inputColumnTypes, inputColumnCategories, isAligned, this.maxRowNumberInStatement);
    }

    @Override
    protected void resetInsertTabletStatementGenerators() {
        this.insertTabletStatementGenerator.reset();
    }

    @Override
    protected boolean processTsBlock(TsBlock inputTsBlock) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return true;
        }
        int readIndex = 0;
        while (readIndex < inputTsBlock.getPositionCount()) {
            readIndex = this.insertTabletStatementGenerator.processTsBlock(inputTsBlock, readIndex);
            if (!this.insertTabletInternally(true)) continue;
            this.cachedTsBlock = inputTsBlock.subTsBlock(readIndex);
            return false;
        }
        return true;
    }

    @Override
    protected TsBlock tryToReturnResultTsBlock() {
        if (this.insertTabletInternally(false)) {
            return null;
        }
        this.finished = true;
        return this.constructResultTsBlock();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + this.insertTabletStatementGenerator.ramBytesUsed();
    }

    private boolean insertTabletInternally(boolean needCheck) {
        InsertTabletStatement insertTabletStatement = this.constructInsertTabletStatement(needCheck);
        if (insertTabletStatement == null) {
            return false;
        }
        this.executeInsertTabletStatement(insertTabletStatement);
        return true;
    }

    private InsertTabletStatement constructInsertTabletStatement(boolean needCheck) {
        if (this.insertTabletStatementGenerator == null || needCheck && !this.insertTabletStatementGenerator.isFull()) {
            return null;
        }
        if (this.insertTabletStatementGenerator.isEmpty()) {
            return null;
        }
        return this.insertTabletStatementGenerator.constructInsertTabletStatement();
    }

    private void executeInsertTabletStatement(InsertTabletStatement insertTabletStatement) {
        if (this.client == null) {
            this.client = new DataNodeInternalClient(this.operatorContext.getSessionInfo());
        }
        this.writeOperationFuture = Futures.submit(() -> this.client.insertRelationalTablet(insertTabletStatement), (Executor)this.writeOperationExecutor);
    }

    private TsBlock constructResultTsBlock() {
        TsBlockBuilder resultTsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        TimeColumnBuilder timeColumnBuilder = resultTsBlockBuilder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(0L);
        ColumnBuilder[] columnBuilders = resultTsBlockBuilder.getValueColumnBuilders();
        columnBuilders[0].writeLong(this.findWritten());
        resultTsBlockBuilder.declarePosition();
        return resultTsBlockBuilder.build();
    }

    private long findWritten() {
        return this.insertTabletStatementGenerator.getWrittenCount();
    }

    private static long getResultTsBlockSize() {
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        TimeColumnBuilder timeColumnBuilder = tsBlockBuilder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(0L);
        ColumnBuilder[] columnBuilders = tsBlockBuilder.getValueColumnBuilders();
        columnBuilders[0].writeLong(0L);
        tsBlockBuilder.declarePosition();
        return tsBlockBuilder.getRetainedSizeInBytes();
    }
}

