/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.dataregion;

import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.runtime.TableLostRuntimeException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeEnrichedInsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsOfOneDeviceNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExecutionVisitor
extends PlanVisitor<TSStatus, DataRegion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataExecutionVisitor.class);

    @Override
    public TSStatus visitPlan(PlanNode node, DataRegion context) {
        return null;
    }

    @Override
    public TSStatus visitRelationalInsertRow(RelationalInsertRowNode node, DataRegion context) {
        return this.visitInsertRow((InsertRowNode)node, context);
    }

    @Override
    public TSStatus visitRelationalInsertRows(RelationalInsertRowsNode node, DataRegion context) {
        return this.visitInsertRows((InsertRowsNode)node, context);
    }

    @Override
    public TSStatus visitInsertRow(InsertRowNode node, DataRegion dataRegion) {
        try {
            dataRegion.insert(node);
            dataRegion.insertSeparatorToWAL();
            return StatusUtils.OK;
        }
        catch (OutOfTTLException e) {
            LOGGER.warn("Error in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (WriteProcessRejectException e) {
            LOGGER.warn("Reject in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (WriteProcessException e) {
            LOGGER.error("Error in executing plan node: {}", (Object)node, (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitRelationalInsertTablet(RelationalInsertTabletNode node, DataRegion dataRegion) {
        return this.visitInsertTablet((InsertTabletNode)node, dataRegion);
    }

    @Override
    public TSStatus visitInsertTablet(InsertTabletNode node, DataRegion dataRegion) {
        try {
            dataRegion.insertTablet(node);
            dataRegion.insertSeparatorToWAL();
            return StatusUtils.OK;
        }
        catch (OutOfTTLException e) {
            LOGGER.warn("Error in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (WriteProcessRejectException e) {
            LOGGER.warn("Reject in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (WriteProcessException e) {
            LOGGER.error("Error in executing plan node: {}", (Object)node, (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (BatchProcessException e) {
            LOGGER.warn("Batch failure in executing a InsertTabletNode. device: {}, startTime: {}, measurements: {}, failing status: {}", new Object[]{node.getTargetPath(), node.getTimes()[0], node.getMeasurements(), e.getFailingStatus()});
            TSStatus firstStatus = null;
            for (TSStatus status : e.getFailingStatus()) {
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    firstStatus = status;
                }
                if (status.getCode() != TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) continue;
                return status;
            }
            return firstStatus;
        }
    }

    @Override
    public TSStatus visitInsertRows(InsertRowsNode node, DataRegion dataRegion) {
        try {
            dataRegion.insert(node);
            dataRegion.insertSeparatorToWAL();
            return StatusUtils.OK;
        }
        catch (WriteProcessRejectException e) {
            LOGGER.warn("Reject in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (BatchProcessException e) {
            LOGGER.warn("Batch failure in executing a InsertRowsNode.");
            TSStatus firstStatus = null;
            for (Map.Entry<Integer, TSStatus> failedEntry : node.getResults().entrySet()) {
                InsertRowNode insertRowNode = node.getInsertRowNodeList().get(failedEntry.getKey());
                if (firstStatus == null) {
                    firstStatus = failedEntry.getValue();
                }
                LOGGER.warn("Insert row failed. device: {}, time: {}, measurements: {}, failing status: {}", new Object[]{insertRowNode.getTargetPath(), insertRowNode.getTime(), insertRowNode.getMeasurements(), failedEntry.getValue()});
                if (failedEntry.getValue().getCode() != TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) continue;
                node.clearResults();
                return failedEntry.getValue();
            }
            return firstStatus;
        }
        catch (TableLostRuntimeException | SemanticException e) {
            LOGGER.error("Error in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
    }

    @Override
    public TSStatus visitInsertMultiTablets(InsertMultiTabletsNode node, DataRegion dataRegion) {
        try {
            dataRegion.insertTablets(node);
            dataRegion.insertSeparatorToWAL();
            return StatusUtils.OK;
        }
        catch (WriteProcessRejectException e) {
            LOGGER.warn("Reject in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (BatchProcessException e) {
            LOGGER.warn("Batch failure in executing a InsertMultiTabletsNode.");
            TSStatus firstStatus = null;
            for (Map.Entry<Integer, TSStatus> failedEntry : node.getResults().entrySet()) {
                InsertTabletNode insertTabletNode = node.getInsertTabletNodeList().get(failedEntry.getKey());
                if (firstStatus == null) {
                    firstStatus = failedEntry.getValue();
                }
                LOGGER.warn("Insert tablet failed. device: {}, startTime: {}, measurements: {}, failing status: {}", new Object[]{insertTabletNode.getTargetPath(), insertTabletNode.getTimes()[0], insertTabletNode.getMeasurements(), failedEntry.getValue()});
                if (failedEntry.getValue().getCode() != TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) continue;
                node.clearResults();
                return failedEntry.getValue();
            }
            return firstStatus;
        }
    }

    @Override
    public TSStatus visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceNode node, DataRegion dataRegion) {
        try {
            dataRegion.insert(node);
            dataRegion.insertSeparatorToWAL();
            return StatusUtils.OK;
        }
        catch (WriteProcessRejectException e) {
            LOGGER.warn("Reject in executing plan node: {}, caused by {}", (Object)node, (Object)e.getMessage());
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (WriteProcessException e) {
            LOGGER.error("Error in executing plan node: {}", (Object)node, (Object)e);
            return RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage());
        }
        catch (BatchProcessException e) {
            LOGGER.warn("Batch failure in executing a InsertRowsOfOneDeviceNode.");
            TSStatus firstStatus = null;
            for (Map.Entry<Integer, TSStatus> failedEntry : node.getResults().entrySet()) {
                InsertRowNode insertRowNode = node.getInsertRowNodeList().get(failedEntry.getKey());
                if (firstStatus == null) {
                    firstStatus = failedEntry.getValue();
                }
                LOGGER.warn("Insert row failed. device: {}, time: {}, measurements: {}, failing status: {}", new Object[]{insertRowNode.getTargetPath(), insertRowNode.getTime(), insertRowNode.getMeasurements(), failedEntry.getValue()});
                if (failedEntry.getValue().getCode() != TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode()) continue;
                node.clearResults();
                return failedEntry.getValue();
            }
            return firstStatus;
        }
    }

    @Override
    public TSStatus visitPipeEnrichedInsertNode(PipeEnrichedInsertNode node, DataRegion context) {
        node.getInsertNode().markAsGeneratedByPipe();
        return node.getInsertNode().accept(this, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSStatus visitDeleteData(DeleteDataNode node, DataRegion dataRegion) {
        dataRegion.writeLock("deleteData");
        try {
            for (MeasurementPath path : node.getPathList()) {
                MeasurementPath databaseToDelete;
                if (path.matchFullPath((PartialPath)(databaseToDelete = new MeasurementPath(dataRegion.getDatabaseName() + ".**"))) || path.getFullPath().equals(databaseToDelete.getFullPath())) {
                    LOGGER.info("now try to delete directly, databasePath: {}, deletePath:{}", (Object)databaseToDelete.getFullPath(), (Object)path.getFullPath());
                    dataRegion.deleteDataDirectly(databaseToDelete, node);
                    continue;
                }
                dataRegion.deleteByDevice(path, node);
            }
            dataRegion.insertSeparatorToWAL();
            TSStatus tSStatus = StatusUtils.OK;
            return tSStatus;
        }
        catch (IOException | IllegalPathException e) {
            LOGGER.error("Error in executing plan node: {}", (Object)node, (Object)e);
            TSStatus tSStatus = new TSStatus(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode());
            return tSStatus;
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    @Override
    public TSStatus visitDeleteData(RelationalDeleteDataNode node, DataRegion dataRegion) {
        try {
            dataRegion.deleteByTable(node);
            dataRegion.insertSeparatorToWAL();
            return StatusUtils.OK;
        }
        catch (IOException e) {
            LOGGER.error("Error in executing plan node: {}", (Object)node, (Object)e);
            return new TSStatus(TSStatusCode.WRITE_PROCESS_ERROR.getStatusCode());
        }
    }

    @Override
    public TSStatus visitPipeEnrichedDeleteDataNode(PipeEnrichedDeleteDataNode node, DataRegion context) {
        node.getDeleteDataNode().markAsGeneratedByPipe();
        return node.getDeleteDataNode().accept(this, context);
    }
}

