/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.ttl.TTLCache;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.tsfile.file.metadata.IDeviceID;

public class DataNodeTTLCache {
    private final TTLCache treeModelTTLCache;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private DataNodeTTLCache() {
        this.treeModelTTLCache = new TTLCache();
    }

    public static DataNodeTTLCache getInstance() {
        return DataNodeTTLCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void setTTLForTree(String path, long ttl) throws IllegalPathException {
        this.lock.writeLock().lock();
        try {
            this.treeModelTTLCache.setTTL(PathUtils.splitPathToDetachedNodes((String)path), ttl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTTLForTree(String[] path, long ttl) {
        this.lock.writeLock().lock();
        try {
            this.treeModelTTLCache.setTTL(path, ttl);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void unsetTTLForTree(String[] path) {
        this.lock.writeLock().lock();
        try {
            this.treeModelTTLCache.unsetTTL(path);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getTTLForTree(IDeviceID deviceID) {
        try {
            return this.getTTLForTree(PathUtils.splitPathToDetachedNodes((String)deviceID.toString()));
        }
        catch (IllegalPathException e) {
            return Long.MAX_VALUE;
        }
    }

    public long getTTLForTable(String database, String table) {
        TsTable tsTable = DataNodeTableCache.getInstance().getTable(database, table, false);
        return tsTable == null ? Long.MAX_VALUE : tsTable.getCachedTableTTL();
    }

    public long getTTLForTree(String[] path) {
        long ttl = this.getTTLInMSForTree(path);
        return ttl == Long.MAX_VALUE ? ttl : CommonDateTimeUtils.convertMilliTimeWithPrecision((long)ttl, (String)CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTTLInMSForTree(String[] path) {
        this.lock.readLock().lock();
        try {
            long l = this.treeModelTTLCache.getClosestTTL(path);
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean dataInDatabaseMayHaveTTL(String db) throws IllegalPathException {
        this.lock.readLock().lock();
        try {
            boolean bl = this.treeModelTTLCache.dataInDatabaseMayHaveTTL(db);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNodeTTLInMSForTree(String path) throws IllegalPathException {
        this.lock.readLock().lock();
        try {
            long l = this.treeModelTTLCache.getLastNodeTTL(PathUtils.splitPathToDetachedNodes((String)path));
            return l;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @TestOnly
    public void clearAllTTLForTree() {
        this.lock.writeLock().lock();
        try {
            this.treeModelTTLCache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class DataNodeTTLCacheHolder {
        private static final DataNodeTTLCache INSTANCE = new DataNodeTTLCache();

        private DataNodeTTLCacheHolder() {
        }
    }
}

