/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.james.jmap.draft.methods.Method;
import org.apache.james.jmap.draft.model.VacationResponse;

public class GetVacationResponse
implements Method.Response {
    private final String accountId;
    private final List<VacationResponse> list;

    public static Builder builder() {
        return new Builder();
    }

    private GetVacationResponse(String accountId, VacationResponse vacationResponse) {
        this.accountId = accountId;
        this.list = ImmutableList.of((Object)vacationResponse);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public List<VacationResponse> getList() {
        return this.list;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetVacationResponse that = (GetVacationResponse)o;
        return Objects.equals(this.accountId, that.accountId) && Objects.equals(this.list, that.list);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.list);
    }

    public static class Builder {
        private String accountId;
        private VacationResponse vacationResponse;

        public Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder vacationResponse(VacationResponse vacationResponse) {
            this.vacationResponse = vacationResponse;
            return this;
        }

        public GetVacationResponse build() {
            Preconditions.checkArgument((this.vacationResponse != null ? 1 : 0) != 0, (Object)"Account should contain exactly one vacation response");
            return new GetVacationResponse(this.accountId, this.vacationResponse);
        }
    }
}

