/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.quota.search.elasticsearch.v7;

import java.io.IOException;
import org.apache.james.backends.es.v7.AliasName;
import org.apache.james.backends.es.v7.ElasticSearchConfiguration;
import org.apache.james.backends.es.v7.IndexCreationFactory;
import org.apache.james.backends.es.v7.IndexName;
import org.apache.james.backends.es.v7.ReactorElasticSearchClient;
import org.apache.james.quota.search.elasticsearch.v7.QuotaRatioElasticSearchConstants;
import org.apache.james.quota.search.elasticsearch.v7.QuotaRatioMappingFactory;

public class QuotaSearchIndexCreationUtil {
    public static ReactorElasticSearchClient prepareClient(ReactorElasticSearchClient client, AliasName readAlias, AliasName writeAlias, IndexName indexName, ElasticSearchConfiguration configuration) {
        return new IndexCreationFactory(configuration).useIndex(indexName).addAlias(readAlias).addAlias(writeAlias).createIndexAndAliases(client, QuotaRatioMappingFactory.getMappingContent());
    }

    public static ReactorElasticSearchClient prepareDefaultClient(ReactorElasticSearchClient client, ElasticSearchConfiguration configuration) throws IOException {
        return QuotaSearchIndexCreationUtil.prepareClient(client, (AliasName)QuotaRatioElasticSearchConstants.DEFAULT_QUOTA_RATIO_READ_ALIAS, (AliasName)QuotaRatioElasticSearchConstants.DEFAULT_QUOTA_RATIO_WRITE_ALIAS, QuotaRatioElasticSearchConstants.DEFAULT_QUOTA_RATIO_INDEX, configuration);
    }
}

