/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.model.BucketedSlices;
import org.apache.james.queue.rabbitmq.view.cassandra.model.EnqueuedItemWithSlicingContext;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;

public class EnqueuedMailsDaoUtil {
    static EnqueuedItemWithSlicingContext toEnqueuedMail(Row row, BlobId.Factory blobFactory) {
        MailQueueName queueName = MailQueueName.fromString(row.getString("queueName"));
        EnqueueId enqueueId = EnqueueId.of(row.getUUID("enqueueId"));
        Instant timeRangeStart = row.getTimestamp("timeRangeStart").toInstant();
        BucketedSlices.BucketId bucketId = BucketedSlices.BucketId.of(row.getInt("bucketId"));
        Instant enqueuedTime = row.getTimestamp("enqueuedTime").toInstant();
        BlobId headerBlobId = blobFactory.from(row.getString("headerBlobId"));
        BlobId bodyBlobId = blobFactory.from(row.getString("bodyBlobId"));
        MimeMessagePartsId mimeMessagePartsId = MimeMessagePartsId.builder().headerBlobId(headerBlobId).bodyBlobId(bodyBlobId).build();
        MailAddress sender = Optional.ofNullable(row.getString("sender")).map(Throwing.function(MailAddress::new)).orElse(null);
        List recipients = (List)row.getList("recipients", String.class).stream().map(Throwing.function(MailAddress::new)).collect(ImmutableList.toImmutableList());
        String state = row.getString("state");
        String remoteAddr = row.getString("remoteAddr");
        String remoteHost = row.getString("remoteHost");
        String errorMessage = row.getString("errorMessage");
        String name = row.getString("name");
        Date lastUpdated = row.getTimestamp("lastUpdated");
        Map rawAttributes = row.getMap("attributes", String.class, ByteBuffer.class);
        PerRecipientHeaders perRecipientHeaders = EnqueuedMailsDaoUtil.fromList(row.getList("perRecipientSpecificHeaders", TupleValue.class));
        MailImpl mail = MailImpl.builder().name(name).sender(sender).addRecipients((Collection)recipients).lastUpdated(lastUpdated).errorMessage(errorMessage).remoteHost(remoteHost).remoteAddr(remoteAddr).state(state).addAllHeadersForRecipients(perRecipientHeaders).addAttributes(EnqueuedMailsDaoUtil.toAttributes(rawAttributes)).build();
        EnqueuedItem enqueuedItem = EnqueuedItem.builder().enqueueId(enqueueId).mailQueueName(queueName).mail((Mail)mail).enqueuedTime(enqueuedTime).mimeMessagePartsId(mimeMessagePartsId).build();
        return EnqueuedItemWithSlicingContext.builder().enqueuedItem(enqueuedItem).slicingContext(EnqueuedItemWithSlicingContext.SlicingContext.of(bucketId, timeRangeStart)).build();
    }

    @VisibleForTesting
    static List<Attribute> toAttributes(Map<String, ByteBuffer> rowAttributes) {
        return (List)rowAttributes.entrySet().stream().map(entry -> new Attribute(AttributeName.of((String)((String)entry.getKey())), EnqueuedMailsDaoUtil.fromByteBuffer((ByteBuffer)entry.getValue()))).collect(ImmutableList.toImmutableList());
    }

    private static AttributeValue<?> fromByteBuffer(ByteBuffer byteBuffer) {
        try {
            return AttributeValue.fromJsonString((String)StandardCharsets.UTF_8.decode(byteBuffer).toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static PerRecipientHeaders fromList(List<TupleValue> list) {
        PerRecipientHeaders result = new PerRecipientHeaders();
        list.forEach(tuple -> result.addHeaderForRecipient(PerRecipientHeaders.Header.builder().name(tuple.getString(1)).value(tuple.getString(2)).build(), EnqueuedMailsDaoUtil.toMailAddress(tuple.getString(0))));
        return result;
    }

    private static MailAddress toMailAddress(String rawValue) {
        try {
            return new MailAddress(rawValue);
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }

    static ImmutableList<String> asStringList(Collection<MailAddress> mailAddresses) {
        return (ImmutableList)mailAddresses.stream().map(MailAddress::asString).collect(ImmutableList.toImmutableList());
    }

    static ImmutableMap<String, ByteBuffer> toRawAttributeMap(Mail mail) {
        return (ImmutableMap)mail.attributes().map(attribute -> Pair.of((Object)attribute.getName().asString(), (Object)EnqueuedMailsDaoUtil.toByteBuffer(attribute.getValue()))).collect(ImmutableMap.toImmutableMap(Pair::getLeft, Pair::getRight));
    }

    private static ByteBuffer toByteBuffer(AttributeValue<?> attributeValue) {
        return ByteBuffer.wrap(attributeValue.toJson().toString().getBytes(StandardCharsets.UTF_8));
    }

    static ImmutableList<TupleValue> toTupleList(TupleType userHeaderNameHeaderValueTriple, PerRecipientHeaders perRecipientHeaders) {
        return (ImmutableList)perRecipientHeaders.getHeadersByRecipient().entries().stream().map(entry -> userHeaderNameHeaderValueTriple.newValue(new Object[]{((MailAddress)entry.getKey()).asString(), ((PerRecipientHeaders.Header)entry.getValue()).getName(), ((PerRecipientHeaders.Header)entry.getValue()).getValue()})).collect(ImmutableList.toImmutableList());
    }
}

