/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Objects;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.cassandra.dto.EventDTO;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationChanged;

class ConfigurationChangedDTO
implements EventDTO {
    private final int eventId;
    private final String aggregateKey;
    private final String type;
    private final int bucketCount;
    private final int updateBrowseStartPace;
    private final Duration sliceWindow;

    static ConfigurationChangedDTO from(ConfigurationChanged configurationChanged, String type) {
        Preconditions.checkNotNull((Object)configurationChanged);
        CassandraMailQueueViewConfiguration configuration = configurationChanged.getConfiguration();
        return new ConfigurationChangedDTO(configurationChanged.eventId().serialize(), configurationChanged.getAggregateId().asAggregateKey(), type, configuration.getBucketCount(), configuration.getUpdateBrowseStartPace(), configuration.getSliceWindow());
    }

    static ConfigurationChangedDTO from(ConfigurationChanged configurationChanged) {
        return ConfigurationChangedDTO.from(configurationChanged, "cassandra-mail-queue-view-configuration");
    }

    @JsonCreator
    ConfigurationChangedDTO(@JsonProperty(value="eventId") int eventId, @JsonProperty(value="aggregateKey") String aggregateKey, @JsonProperty(value="type") String type, @JsonProperty(value="bucketCount") int bucketCount, @JsonProperty(value="updateBrowseStartPace") int updateBrowseStartPace, @JsonProperty(value="sliceWindow") Duration sliceWindow) {
        this.eventId = eventId;
        this.aggregateKey = aggregateKey;
        this.type = type;
        this.bucketCount = bucketCount;
        this.updateBrowseStartPace = updateBrowseStartPace;
        this.sliceWindow = sliceWindow;
    }

    @JsonIgnore
    public ConfigurationChanged toEvent() {
        return new ConfigurationChanged(() -> this.aggregateKey, EventId.fromSerialized((int)this.eventId), CassandraMailQueueViewConfiguration.builder().bucketCount(this.bucketCount).updateBrowseStartPace(this.updateBrowseStartPace).sliceWindow(this.sliceWindow).build());
    }

    public int getEventId() {
        return this.eventId;
    }

    public String getAggregateKey() {
        return this.aggregateKey;
    }

    public String getType() {
        return this.type;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public int getUpdateBrowseStartPace() {
        return this.updateBrowseStartPace;
    }

    public Duration getSliceWindow() {
        return this.sliceWindow;
    }

    public final boolean equals(Object o) {
        if (o instanceof ConfigurationChangedDTO) {
            ConfigurationChangedDTO that = (ConfigurationChangedDTO)o;
            return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.aggregateKey, that.aggregateKey) && Objects.equals(this.type, that.type) && Objects.equals(this.bucketCount, that.bucketCount) && Objects.equals(this.updateBrowseStartPace, that.updateBrowseStartPace) && Objects.equals(this.sliceWindow, that.sliceWindow);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.eventId, this.aggregateKey, this.type, this.bucketCount, this.updateBrowseStartPace, this.sliceWindow);
    }
}

