/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.mailet.LoopPrevention;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.LoggerFactory;

public class IsSenderInRRTLoop
extends GenericMatcher {
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    public IsSenderInRRTLoop(RecipientRewriteTable recipientRewriteTable) {
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public Collection<MailAddress> match(Mail mail) {
        try {
            if (mail.hasSender()) {
                this.recipientRewriteTable.getResolvedMappings(mail.getMaybeSender().get().getLocalPart(), mail.getMaybeSender().get().getDomain());
            }
        }
        catch (RecipientRewriteTable.TooManyMappingException e) {
            return mail.getRecipients();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(IsSenderInRRTLoop.class).warn("Error while executing RRT");
        }
        return mail.getMaybeSender().asOptional().filter(sender -> IsSenderInRRTLoop.recordedRecipientsContainSender(mail, sender)).map(any -> mail.getRecipients()).orElse((Collection)ImmutableList.of());
    }

    private static boolean recordedRecipientsContainSender(Mail mail, MailAddress sender) {
        return LoopPrevention.RecordedRecipients.fromMail((Mail)mail).getRecipients().contains(sender);
    }
}

