/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.minbin;

import java.util.Iterator;
import org.nustaq.serialization.minbin.MBIn;
import org.nustaq.serialization.minbin.MBObject;
import org.nustaq.serialization.minbin.MBOut;
import org.nustaq.serialization.minbin.MBSequence;
import org.nustaq.serialization.minbin.MinBin;

public class MBTags {

    public static class RefTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            out.writeInt((byte)3, ((Number)data).intValue());
        }

        @Override
        public Object readTag(MBIn in) {
            return (int)in.readInt();
        }

        @Override
        public Class getClassEncoded() {
            return null;
        }
    }

    public static class BigBoolTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            out.writeInt((byte)1, (Boolean)data != false ? 1L : 0L);
        }

        @Override
        public Object readTag(MBIn in) {
            return in.readInt() == 0L ? Boolean.FALSE : Boolean.TRUE;
        }

        @Override
        public Class getClassEncoded() {
            return Boolean.class;
        }
    }

    public static class MBSequenceTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            MBSequence ob = (MBSequence)data;
            out.writeTag(ob.getTypeInfo());
            out.writeIntPacked(ob.size());
            for (int i = 0; i < ob.size(); ++i) {
                Object o = ob.get(i);
                out.writeObject(o);
            }
        }

        @Override
        public Object readTag(MBIn in) {
            Object o;
            Object typeInfo = in.readObject();
            int len = (int)in.readInt();
            if (len == -1) {
                len = Integer.MAX_VALUE;
            }
            MBSequence obj = new MBSequence(typeInfo);
            for (int i = 0; i < len && MinBin.END_MARKER != (o = in.readObject()); ++i) {
                obj.add(o);
            }
            return obj;
        }

        @Override
        public Class getClassEncoded() {
            return MBSequence.class;
        }
    }

    public static class MBObjectTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            MBObject ob = (MBObject)data;
            out.writeObject(ob.getTypeInfo());
            out.writeIntPacked(ob.size());
            Iterator<String> iterator = ob.keyIterator();
            while (iterator.hasNext()) {
                String next = iterator.next();
                out.writeTag(next);
                out.writeObject(ob.get(next));
            }
        }

        @Override
        public Object readTag(MBIn in) {
            Object key;
            Object typeInfo = in.readObject();
            int len = (int)in.readInt();
            if (len == -1) {
                len = Integer.MAX_VALUE;
            }
            MBObject obj = new MBObject(typeInfo);
            for (int i = 0; i < len && MinBin.END_MARKER != (key = in.readObject()); ++i) {
                obj.put((String)key, in.readObject());
            }
            return obj;
        }

        @Override
        public Class getClassEncoded() {
            return MBObject.class;
        }
    }

    public static class FloatArrTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            float[] d = (float[])data;
            out.writeIntPacked(((double[])data).length);
            for (int i = 0; i < d.length; ++i) {
                byte[] bytes = Float.toString(d[i]).getBytes();
                out.writeArray(bytes, 0, bytes.length);
            }
        }

        @Override
        public Object readTag(MBIn in) {
            int len = (int)in.readInt();
            float[] res = new float[len];
            for (int i = 0; i < len; ++i) {
                byte[] ba = (byte[])in.readArray();
                res[i] = Float.parseFloat(new String(ba, 0, 0, ba.length));
            }
            return res;
        }

        @Override
        public Class getClassEncoded() {
            return float[].class;
        }
    }

    public static class DoubleArrTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            double[] d = (double[])data;
            out.writeIntPacked(((double[])data).length);
            for (int i = 0; i < d.length; ++i) {
                byte[] bytes = Double.toString(d[i]).getBytes();
                out.writeArray(bytes, 0, bytes.length);
            }
        }

        @Override
        public Object readTag(MBIn in) {
            int len = (int)in.readInt();
            double[] res = new double[len];
            for (int i = 0; i < len; ++i) {
                byte[] ba = (byte[])in.readArray();
                res[i] = Double.parseDouble(new String(ba, 0, 0, ba.length));
            }
            return res;
        }

        @Override
        public Class getClassEncoded() {
            return double[].class;
        }
    }

    public static class FloatTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            byte[] bytes = Float.toString(((Float)data).floatValue()).getBytes();
            out.writeArray(bytes, 0, bytes.length);
        }

        @Override
        public Object readTag(MBIn in) {
            byte[] ba = (byte[])in.readArray();
            return Float.valueOf(Float.parseFloat(new String(ba, 0, 0, ba.length)));
        }

        @Override
        public Class getClassEncoded() {
            return Float.class;
        }
    }

    public static class DoubleTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            double d = (Double)data;
            byte[] bytes = Double.toString(d).getBytes();
            out.writeArray(bytes, 0, bytes.length);
        }

        @Override
        public Object readTag(MBIn in) {
            byte[] ba = (byte[])in.readArray();
            return Double.parseDouble(new String(ba, 0, 0, ba.length));
        }

        @Override
        public Class getClassEncoded() {
            return Double.class;
        }
    }

    public static class StringTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
            boolean isAsc;
            String s2 = (String)data;
            boolean bl = isAsc = s2.length() < 64;
            if (isAsc) {
                for (int i = 0; i < s2.length(); ++i) {
                    if (s2.charAt(i) < '\u007f') continue;
                    isAsc = false;
                    break;
                }
            }
            if (isAsc) {
                byte[] strBytes = s2.getBytes();
                out.writeOut((byte)17);
                out.writeIntPacked(strBytes.length);
                out.writeRaw(strBytes, 0, strBytes.length);
            } else {
                char[] chars = s2.toCharArray();
                out.writeArray(chars, 0, chars.length);
            }
        }

        @Override
        public Object readTag(MBIn in) {
            Object arr = in.readArray();
            if (arr instanceof byte[]) {
                byte[] ba = (byte[])arr;
                return new String(ba, 0, 0, ba.length);
            }
            if (arr instanceof char[]) {
                char[] ca = (char[])arr;
                return new String(ca, 0, ca.length);
            }
            return null;
        }

        @Override
        public Class getClassEncoded() {
            return String.class;
        }
    }

    public static class NullTagSer
    extends MinBin.TagSerializer {
        @Override
        public void writeTag(Object data, MBOut out) {
        }

        @Override
        public Object readTag(MBIn in) {
            return null;
        }

        @Override
        public Class getClassEncoded() {
            return Object.class;
        }
    }
}

