/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.message.BasicBodyFactory;
import org.apache.james.mime4j.message.BodyFactory;
import org.apache.james.mime4j.util.ContentUtil;

public class SingleBodyBuilder {
    private String text;
    private byte[] bin;
    private Charset charset;
    private BodyFactory bodyFactory;

    public static SingleBodyBuilder create() {
        return new SingleBodyBuilder();
    }

    public static SingleBodyBuilder createCopy(SingleBody other) throws IOException {
        return new SingleBodyBuilder().copy(other);
    }

    SingleBodyBuilder() {
    }

    public SingleBodyBuilder use(BodyFactory bodyFactory) {
        this.bodyFactory = bodyFactory;
        return this;
    }

    public SingleBodyBuilder setText(String text) {
        this.text = text;
        this.bin = null;
        return this;
    }

    public SingleBodyBuilder setByteArray(byte[] bin) {
        this.bin = bin;
        this.text = null;
        return this;
    }

    public SingleBodyBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public SingleBodyBuilder readFrom(InputStream in) throws IOException {
        this.bin = ContentUtil.buffer(in);
        this.text = null;
        return this;
    }

    public SingleBodyBuilder readFrom(Reader in) throws IOException {
        this.text = ContentUtil.buffer(in);
        this.bin = null;
        return this;
    }

    public SingleBodyBuilder copy(SingleBody other) throws IOException {
        if (other == null) {
            return this;
        }
        if (other instanceof TextBody) {
            this.charset = ((TextBody)other).getCharset();
        }
        this.bin = ContentUtil.buffer(other.getInputStream());
        return this;
    }

    public TextBody buildText() throws IOException {
        Charset cs;
        Charset charset = cs = this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET;
        if (this.bodyFactory != null) {
            if (this.text != null) {
                return this.bodyFactory.textBody(InputStreams.create(this.text, cs), cs.name());
            }
            if (this.bin != null) {
                return this.bodyFactory.textBody(InputStreams.create(this.bin), cs.name());
            }
            return this.bodyFactory.textBody(InputStreams.create(new byte[0]), cs.name());
        }
        if (this.text != null) {
            return BasicBodyFactory.INSTANCE.textBody(this.text, cs);
        }
        if (this.bin != null) {
            return BasicBodyFactory.INSTANCE.textBody(this.bin, cs);
        }
        return BasicBodyFactory.INSTANCE.textBody(new byte[0], cs);
    }

    public BinaryBody buildBinary() throws IOException {
        Charset cs;
        Charset charset = cs = this.charset != null ? this.charset : Charsets.DEFAULT_CHARSET;
        if (this.bodyFactory != null) {
            if (this.text != null) {
                return this.bodyFactory.binaryBody(InputStreams.create(this.text, cs));
            }
            if (this.bin != null) {
                return this.bodyFactory.binaryBody(InputStreams.create(this.bin));
            }
            return this.bodyFactory.binaryBody(InputStreams.create(new byte[0]));
        }
        if (this.bin != null) {
            return BasicBodyFactory.INSTANCE.binaryBody(this.bin);
        }
        if (this.text != null) {
            return BasicBodyFactory.INSTANCE.binaryBody(this.text, cs);
        }
        return BasicBodyFactory.INSTANCE.binaryBody(new byte[0]);
    }

    public SingleBody build() throws IOException {
        if (this.charset != null) {
            return this.buildText();
        }
        return this.buildBinary();
    }
}

