/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class BucketedSlices {

    public static class Slice {
        private final Instant startSliceInstant;

        public static Slice of(Instant sliceStartInstant) {
            return new Slice(sliceStartInstant);
        }

        private static long calculateSliceCount(Slice firstSlice, Instant endAt, Duration windowSize) {
            long startAtSeconds = firstSlice.getStartSliceInstant().getEpochSecond();
            long endAtSeconds = endAt.getEpochSecond();
            long timeDiffInSecond = endAtSeconds - startAtSeconds;
            if (timeDiffInSecond < 0L) {
                return 0L;
            }
            return timeDiffInSecond / windowSize.getSeconds() + 1L;
        }

        private Slice(Instant startSliceInstant) {
            Preconditions.checkNotNull((Object)startSliceInstant);
            this.startSliceInstant = startSliceInstant;
        }

        public Instant getStartSliceInstant() {
            return this.startSliceInstant;
        }

        public Stream<Slice> allSlicesTill(Instant endAt, Duration windowSize) {
            long sliceCount = Slice.calculateSliceCount(this, endAt, windowSize);
            long startAtSeconds = this.getStartSliceInstant().getEpochSecond();
            long sliceWindowSizeInSecond = windowSize.getSeconds();
            return LongStream.range(0L, sliceCount).map(slicePosition -> startAtSeconds + sliceWindowSizeInSecond * slicePosition).mapToObj(Instant::ofEpochSecond).map(Slice::of);
        }

        public final boolean equals(Object o) {
            if (o instanceof Slice) {
                Slice slice = (Slice)o;
                return Objects.equals(this.startSliceInstant, slice.startSliceInstant);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.startSliceInstant);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("startSliceInstant", (Object)this.startSliceInstant).toString();
        }
    }

    public static class BucketId {
        private final int value;

        public static BucketId of(int bucketId) {
            return new BucketId(bucketId);
        }

        public static BucketId of(String value, int bucketCount) {
            int mailKeyHashCode = value.hashCode();
            return BucketId.of(mailKeyHashCode, bucketCount);
        }

        @VisibleForTesting
        public static BucketId of(int mailKeyHashCode, int bucketCount) {
            int bucketIdValue = Math.abs(mailKeyHashCode % bucketCount);
            return BucketId.of(bucketIdValue);
        }

        private BucketId(int value) {
            Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"bucketId should not be negative");
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof BucketId) {
                BucketId bucketId = (BucketId)o;
                return Objects.equals(this.value, bucketId.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

