/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import io.netty.channel.ChannelHandlerContext;
import java.util.Optional;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.handler.ProtocolHandlerResultHandler;
import org.apache.james.protocols.netty.BasicChannelInboundHandler;
import org.apache.james.protocols.netty.Encryption;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.protocols.smtp.core.SMTPMDCContextFactory;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.SMTPConstants;
import org.apache.james.smtpserver.netty.SmtpMetrics;

public class SMTPChannelInboundHandler
extends BasicChannelInboundHandler {
    private final SmtpMetrics smtpMetrics;

    public SMTPChannelInboundHandler(Protocol protocol, Encryption encryption, boolean proxyRequired, SmtpMetrics smtpMetrics) {
        super((ProtocolMDCContextFactory)new SMTPMDCContextFactory(), protocol, encryption, proxyRequired);
        this.smtpMetrics = smtpMetrics;
        this.resultHandlers.add(this.recordCommandCount(smtpMetrics));
    }

    public SMTPChannelInboundHandler(Protocol protocol, SmtpMetrics smtpMetrics) {
        super((ProtocolMDCContextFactory)new SMTPMDCContextFactory(), protocol);
        this.smtpMetrics = smtpMetrics;
        this.resultHandlers.add(this.recordCommandCount(smtpMetrics));
    }

    private ProtocolHandlerResultHandler recordCommandCount(SmtpMetrics smtpMetrics) {
        return (session, response, executionTime, handler) -> {
            smtpMetrics.getCommandsMetric().increment();
            return response;
        };
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.smtpMetrics.getConnectionMetric().increment();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.smtpMetrics.getConnectionMetric().decrement();
    }

    protected void cleanup(ChannelHandlerContext ctx) {
        ExtendedSMTPSession smtpSession = (ExtendedSMTPSession)((Object)ctx.channel().attr(SMTPConstants.SMTP_SESSION_ATTRIBUTE_KEY).get());
        if (smtpSession != null) {
            smtpSession.getAttachment(SMTPConstants.MAIL, ProtocolSession.State.Transaction).ifPresent(LifecycleUtil::dispose);
            Optional.ofNullable(smtpSession.getMimeMessageWriter()).ifPresent(LifecycleUtil::dispose);
        }
        super.cleanup(ctx);
    }
}

