/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.PasswordPolicyStateJSONField;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.RecentLoginHistory;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityError;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityNotice;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordPolicyStateAccountUsabilityWarning;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordQualityRequirement;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordPolicyStateJSON
implements Serializable {
    @NotNull
    public static final String PASSWORD_POLICY_STATE_JSON_ATTRIBUTE = "ds-pwp-state-json";
    @NotNull
    private static final String REQUIREMENT_FIELD_APPLIES_TO_ADD = "applies-to-add";
    @NotNull
    private static final String REQUIREMENT_FIELD_APPLIES_TO_ADMIN_RESET = "applies-to-administrative-reset";
    @NotNull
    private static final String REQUIREMENT_FIELD_APPLIES_TO_BIND = "applies-to-bind";
    @NotNull
    private static final String REQUIREMENT_FIELD_APPLIES_TO_SELF_CHANGE = "applies-to-self-change";
    @NotNull
    private static final String REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES = "client-side-validation-properties";
    @NotNull
    private static final String REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_PROPERTY_NAME = "name";
    @NotNull
    private static final String REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_PROPERTY_VALUE = "value";
    @NotNull
    private static final String REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_TYPE = "client-side-validation-type";
    @NotNull
    private static final String REQUIREMENT_FIELD_DESCRIPTION = "description";
    @NotNull
    private static final String USABILITY_FIELD_MESSAGE = "message";
    @NotNull
    private static final String USABILITY_FIELD_TYPE_ID = "type-id";
    @NotNull
    private static final String USABILITY_FIELD_TYPE_NAME = "type-name";
    @NotNull
    private static final String NON_CURRENT_ENCODING_FIELD_SCHEME = "scheme";
    @NotNull
    private static final String NON_CURRENT_ENCODING_FIELD_EXPLANATIONS = "explanations";
    private static final long serialVersionUID = -3953182526241789456L;
    @NotNull
    private final JSONObject passwordPolicyStateObject;

    public PasswordPolicyStateJSON(@NotNull JSONObject passwordPolicyStateObject) {
        this.passwordPolicyStateObject = passwordPolicyStateObject;
    }

    @Nullable
    public static PasswordPolicyStateJSON get(@NotNull LDAPInterface connection, @NotNull String userDN) throws LDAPException {
        SearchResultEntry userEntry = connection.getEntry(userDN, PASSWORD_POLICY_STATE_JSON_ATTRIBUTE);
        if (userEntry == null) {
            throw new LDAPException(ResultCode.NO_SUCH_OBJECT, UnboundIDDSMessages.ERR_PW_POLICY_STATE_JSON_GET_NO_SUCH_USER.get(userDN));
        }
        return PasswordPolicyStateJSON.get(userEntry);
    }

    @Nullable
    public static PasswordPolicyStateJSON get(@NotNull Entry userEntry) throws LDAPException {
        JSONObject jsonObject;
        String valueString = userEntry.getAttributeValue(PASSWORD_POLICY_STATE_JSON_ATTRIBUTE);
        if (valueString == null) {
            return null;
        }
        try {
            jsonObject = new JSONObject(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, UnboundIDDSMessages.ERR_PW_POLICY_STATE_JSON_GET_CANNOT_DECODE.get(PASSWORD_POLICY_STATE_JSON_ATTRIBUTE, userEntry.getDN()), e);
        }
        return new PasswordPolicyStateJSON(jsonObject);
    }

    @NotNull
    public JSONObject getPasswordPolicyStateJSONObject() {
        return this.passwordPolicyStateObject;
    }

    @Nullable
    public String getPasswordPolicyDN() {
        return this.passwordPolicyStateObject.getFieldAsString(PasswordPolicyStateJSONField.PASSWORD_POLICY_DN.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsUsable() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_USABLE.getFieldName());
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityError> getAccountUsabilityErrors() {
        ArrayList<PasswordPolicyStateAccountUsabilityError> errors = new ArrayList<PasswordPolicyStateAccountUsabilityError>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.ACCOUNT_USABILITY_ERRORS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject o = (JSONObject)v;
                String typeName = o.getFieldAsString(USABILITY_FIELD_TYPE_NAME);
                Integer typeID = o.getFieldAsInteger(USABILITY_FIELD_TYPE_ID);
                String message = o.getFieldAsString(USABILITY_FIELD_MESSAGE);
                if (typeName == null || typeID == null) continue;
                errors.add(new PasswordPolicyStateAccountUsabilityError(typeID, typeName, message));
            }
        }
        return Collections.unmodifiableList(errors);
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityWarning> getAccountUsabilityWarnings() {
        ArrayList<PasswordPolicyStateAccountUsabilityWarning> warnings = new ArrayList<PasswordPolicyStateAccountUsabilityWarning>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.ACCOUNT_USABILITY_WARNINGS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject o = (JSONObject)v;
                String typeName = o.getFieldAsString(USABILITY_FIELD_TYPE_NAME);
                Integer typeID = o.getFieldAsInteger(USABILITY_FIELD_TYPE_ID);
                String message = o.getFieldAsString(USABILITY_FIELD_MESSAGE);
                if (typeName == null || typeID == null) continue;
                warnings.add(new PasswordPolicyStateAccountUsabilityWarning(typeID, typeName, message));
            }
        }
        return Collections.unmodifiableList(warnings);
    }

    @NotNull
    public List<PasswordPolicyStateAccountUsabilityNotice> getAccountUsabilityNotices() {
        ArrayList<PasswordPolicyStateAccountUsabilityNotice> notices = new ArrayList<PasswordPolicyStateAccountUsabilityNotice>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.ACCOUNT_USABILITY_NOTICES.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                if (!(v instanceof JSONObject)) continue;
                JSONObject o = (JSONObject)v;
                String typeName = o.getFieldAsString(USABILITY_FIELD_TYPE_NAME);
                Integer typeID = o.getFieldAsInteger(USABILITY_FIELD_TYPE_ID);
                String message = o.getFieldAsString(USABILITY_FIELD_MESSAGE);
                if (typeName == null || typeID == null) continue;
                notices.add(new PasswordPolicyStateAccountUsabilityNotice(typeID, typeName, message));
            }
        }
        return Collections.unmodifiableList(notices);
    }

    @Nullable
    public Boolean getHasStaticPassword() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_STATIC_PASSWORD.getFieldName());
    }

    @Nullable
    public Date getPasswordChangedTime() {
        return this.getDate(PasswordPolicyStateJSONField.PASSWORD_CHANGED_TIME);
    }

    @Nullable
    public Integer getSecondsSincePasswordChange() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_PASSWORD_CHANGE.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsDisabled() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_DISABLED.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsNotYetActive() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_NOT_YET_ACTIVE.getFieldName());
    }

    @Nullable
    public Date getAccountActivationTime() {
        return this.getDate(PasswordPolicyStateJSONField.ACCOUNT_ACTIVATION_TIME);
    }

    @Nullable
    public Integer getSecondsUntilAccountActivation() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_ACCOUNT_ACTIVATION.getFieldName());
    }

    @Nullable
    public Integer getSecondsSinceAccountActivation() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_ACCOUNT_ACTIVATION.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsExpired() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_EXPIRED.getFieldName());
    }

    @Nullable
    public Date getAccountExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.ACCOUNT_EXPIRATION_TIME);
    }

    @Nullable
    public Integer getSecondsUntilAccountExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_ACCOUNT_EXPIRATION.getFieldName());
    }

    @Nullable
    public Integer getSecondsSinceAccountExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_ACCOUNT_EXPIRATION.getFieldName());
    }

    @Nullable
    public Boolean getPasswordIsExpired() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.PASSWORD_IS_EXPIRED.getFieldName());
    }

    @Nullable
    public Integer getMaximumPasswordAgeSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_AGE_SECONDS.getFieldName());
    }

    @Nullable
    public Date getPasswordExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_TIME);
    }

    @Nullable
    public Integer getSecondsUntilPasswordExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_PASSWORD_EXPIRATION.getFieldName());
    }

    @Nullable
    public Integer getSecondsSincePasswordExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_PASSWORD_EXPIRATION.getFieldName());
    }

    @Nullable
    public Integer getPasswordExpirationWarningIntervalSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNING_INTERVAL_SECONDS.getFieldName());
    }

    @Nullable
    public Boolean getExpirePasswordsWithoutWarning() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.EXPIRE_PASSWORDS_WITHOUT_WARNING.getFieldName());
    }

    @Nullable
    public Boolean getPasswordExpirationWarningIssued() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNING_ISSUED.getFieldName());
    }

    @Nullable
    public Date getPasswordExpirationWarningTime() {
        return this.getDate(PasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNING_TIME);
    }

    @Nullable
    public Integer getSecondsUntilPasswordExpirationWarning() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING.getFieldName());
    }

    @Nullable
    public Integer getSecondsSincePasswordExpirationWarning() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_PASSWORD_EXPIRATION_WARNING.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsFailureLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_FAILURE_LOCKED.getFieldName());
    }

    @Nullable
    public Integer getFailureLockoutCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_COUNT.getFieldName());
    }

    @Nullable
    public Integer getCurrentAuthenticationFailureCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.CURRENT_AUTHENTICATION_FAILURE_COUNT.getFieldName());
    }

    @Nullable
    public Integer getRemainingAuthenticationFailureCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.REMAINING_AUTHENTICATION_FAILURE_COUNT.getFieldName());
    }

    @NotNull
    public List<Date> getAuthenticationFailureTimes() {
        ArrayList<Date> authFailureTimes = new ArrayList<Date>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.AUTHENTICATION_FAILURE_TIMES.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    String valueString = ((JSONString)v).stringValue();
                    authFailureTimes.add(StaticUtils.decodeRFC3339Time(valueString));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(authFailureTimes);
    }

    @Nullable
    public Date getFailureLockoutTime() {
        return this.getDate(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_TIME);
    }

    @Nullable
    public Integer getFailureLockoutDurationSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_DURATION_SECONDS.getFieldName());
    }

    @Nullable
    public Date getFailureLockoutExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.FAILURE_LOCKOUT_EXPIRATION_TIME);
    }

    @Nullable
    public Integer getSecondsRemainingInFailureLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_REMAINING_IN_FAILURE_LOCKOUT.getFieldName());
    }

    @Nullable
    public Date getLastLoginTime() {
        return this.getDate(PasswordPolicyStateJSONField.LAST_LOGIN_TIME);
    }

    @Nullable
    public Integer getSecondsSinceLastLogin() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_LAST_LOGIN.getFieldName());
    }

    @Nullable
    public String getLastLoginIPAddress() {
        return this.passwordPolicyStateObject.getFieldAsString(PasswordPolicyStateJSONField.LAST_LOGIN_IP_ADDRESS.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsIdleLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_IDLE_LOCKED.getFieldName());
    }

    @Nullable
    public Integer getIdleLockoutIntervalSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.IDLE_LOCKOUT_INTERVAL_SECONDS.getFieldName());
    }

    @Nullable
    public Date getIdleLockoutTime() {
        return this.getDate(PasswordPolicyStateJSONField.IDLE_LOCKOUT_TIME);
    }

    @Nullable
    public Integer getSecondsUntilIdleLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_IDLE_LOCKOUT.getFieldName());
    }

    @Nullable
    public Integer getSecondsSinceIdleLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_IDLE_LOCKOUT.getFieldName());
    }

    @Nullable
    public Boolean getMustChangePassword() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.MUST_CHANGE_PASSWORD.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsResetLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_RESET_LOCKED.getFieldName());
    }

    @Nullable
    public Boolean getForceChangeOnAdd() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.FORCE_CHANGE_ON_ADD.getFieldName());
    }

    @Nullable
    public Boolean getForceChangeOnReset() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.FORCE_CHANGE_ON_RESET.getFieldName());
    }

    @Nullable
    public Integer getMaximumPasswordResetAgeSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_RESET_AGE_SECONDS.getFieldName());
    }

    @Nullable
    public Date getResetLockoutTime() {
        return this.getDate(PasswordPolicyStateJSONField.RESET_LOCKOUT_TIME);
    }

    @Nullable
    public Integer getSecondsUntilResetLockout() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_RESET_LOCKOUT.getFieldName());
    }

    @Nullable
    public Integer getMaximumPasswordHistoryCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_HISTORY_COUNT.getFieldName());
    }

    @Nullable
    public Integer getMaximumPasswordHistoryDurationSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_PASSWORD_HISTORY_DURATION_SECONDS.getFieldName());
    }

    @Nullable
    public Integer getCurrentPasswordHistoryCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.CURRENT_PASSWORD_HISTORY_COUNT.getFieldName());
    }

    @Nullable
    public Boolean getIsWithinMinimumPasswordAge() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.IS_WITHIN_MINIMUM_PASSWORD_AGE.getFieldName());
    }

    @Nullable
    public Integer getMinimumPasswordAgeSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MINIMUM_PASSWORD_AGE_SECONDS.getFieldName());
    }

    @Nullable
    public Date getMinimumPasswordAgeExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.MINIMUM_PASSWORD_AGE_EXPIRATION_TIME);
    }

    @Nullable
    public Integer getSecondsRemainingInMinimumPasswordAge() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_REMAINING_IN_MINIMUM_PASSWORD_AGE.getFieldName());
    }

    @Nullable
    public Integer getMaximumGraceLoginCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_GRACE_LOGIN_COUNT.getFieldName());
    }

    @Nullable
    public Integer getUsedGraceLoginCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.USED_GRACE_LOGIN_COUNT.getFieldName());
    }

    @Nullable
    public Integer getRemainingGraceLoginCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.REMAINING_GRACE_LOGIN_COUNT.getFieldName());
    }

    @NotNull
    public List<Date> getGraceLoginUseTimes() {
        ArrayList<Date> graceLoginTimes = new ArrayList<Date>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.GRACE_LOGIN_USE_TIMES.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    String valueString = ((JSONString)v).stringValue();
                    graceLoginTimes.add(StaticUtils.decodeRFC3339Time(valueString));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(graceLoginTimes);
    }

    @Nullable
    public Boolean getHasRetiredPassword() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_RETIRED_PASSWORD.getFieldName());
    }

    @Nullable
    public Date getRetiredPasswordExpirationTime() {
        return this.getDate(PasswordPolicyStateJSONField.RETIRED_PASSWORD_EXPIRATION_TIME);
    }

    @Nullable
    public Integer getSecondsUntilRetiredPasswordExpiration() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_UNTIL_RETIRED_PASSWORD_EXPIRATION.getFieldName());
    }

    @Nullable
    public Boolean getRequireSecureAuthentication() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.REQUIRE_SECURE_AUTHENTICATION.getFieldName());
    }

    @Nullable
    public Boolean getRequireSecurePasswordChanges() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.REQUIRE_SECURE_PASSWORD_CHANGES.getFieldName());
    }

    @NotNull
    public List<String> getAvailableSASLMechanisms() {
        ArrayList<String> saslMechanismNames = new ArrayList<String>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.AVAILABLE_SASL_MECHANISMS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    saslMechanismNames.add(((JSONString)v).stringValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(saslMechanismNames);
    }

    @NotNull
    public List<String> getAvailableOTPDeliveryMechanisms() {
        ArrayList<String> deliveryMechanismNames = new ArrayList<String>();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.AVAILABLE_OTP_DELIVERY_MECHANISMS.getFieldName());
        if (values != null) {
            for (JSONValue v : values) {
                try {
                    deliveryMechanismNames.add(((JSONString)v).stringValue());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
        }
        return Collections.unmodifiableList(deliveryMechanismNames);
    }

    @Nullable
    public Boolean getHasTOTPSharedSecret() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_TOTP_SHARED_SECRET.getFieldName());
    }

    @Nullable
    public Boolean getHasRegisteredYubiKeyOTPDevice() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_REGISTERED_YUBIKEY_OTP_DEVICE.getFieldName());
    }

    @Nullable
    public Boolean getAccountIsValidationLocked() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.ACCOUNT_IS_VALIDATION_LOCKED.getFieldName());
    }

    @Nullable
    public Date getLastBindPasswordValidationTime() {
        return this.getDate(PasswordPolicyStateJSONField.LAST_BIND_PASSWORD_VALIDATION_TIME);
    }

    @Nullable
    public Integer getSecondsSinceLastBindPasswordValidation() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.SECONDS_SINCE_LAST_BIND_PASSWORD_VALIDATION.getFieldName());
    }

    @Nullable
    public Integer getMinimumBindPasswordValidationFrequencySeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MINIMUM_BIND_PASSWORD_VALIDATION_FREQUENCY_SECONDS.getFieldName());
    }

    @Nullable
    public String getBindPasswordValidationFailureAction() {
        return this.passwordPolicyStateObject.getFieldAsString(PasswordPolicyStateJSONField.BIND_PASSWORD_VALIDATION_FAILURE_ACTION.getFieldName());
    }

    @Nullable
    public RecentLoginHistory getRecentLoginHistory() throws LDAPException {
        JSONObject o = this.passwordPolicyStateObject.getFieldAsObject(PasswordPolicyStateJSONField.RECENT_LOGIN_HISTORY.getFieldName());
        if (o == null) {
            return null;
        }
        return new RecentLoginHistory(o);
    }

    @Nullable
    public Integer getMaximumRecentLoginHistorySuccessfulAuthenticationCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_RECENT_LOGIN_HISTORY_SUCCESSFUL_AUTHENTICATION_COUNT.getFieldName());
    }

    @Nullable
    public Integer getMaximumRecentLoginHistorySuccessfulAuthenticationDurationSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_RECENT_LOGIN_HISTORY_SUCCESSFUL_AUTHENTICATION_DURATION_SECONDS.getFieldName());
    }

    @Nullable
    public Integer getMaximumRecentLoginHistoryFailedAuthenticationCount() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_RECENT_LOGIN_HISTORY_FAILED_AUTHENTICATION_COUNT.getFieldName());
    }

    @Nullable
    public Integer getMaximumRecentLoginHistoryFailedAuthenticationDurationSeconds() {
        return this.passwordPolicyStateObject.getFieldAsInteger(PasswordPolicyStateJSONField.MAXIMUM_RECENT_LOGIN_HISTORY_FAILED_AUTHENTICATION_DURATION_SECONDS.getFieldName());
    }

    @NotNull
    public List<PasswordQualityRequirement> getAddPasswordQualityRequirements() {
        return this.getPasswordQualityRequirements(REQUIREMENT_FIELD_APPLIES_TO_ADD);
    }

    @NotNull
    public List<PasswordQualityRequirement> getSelfChangePasswordQualityRequirements() {
        return this.getPasswordQualityRequirements(REQUIREMENT_FIELD_APPLIES_TO_SELF_CHANGE);
    }

    @NotNull
    public List<PasswordQualityRequirement> getAdministrativeResetPasswordQualityRequirements() {
        return this.getPasswordQualityRequirements(REQUIREMENT_FIELD_APPLIES_TO_ADMIN_RESET);
    }

    @NotNull
    public List<PasswordQualityRequirement> getBindPasswordQualityRequirements() {
        return this.getPasswordQualityRequirements(REQUIREMENT_FIELD_APPLIES_TO_BIND);
    }

    @NotNull
    private List<PasswordQualityRequirement> getPasswordQualityRequirements(@NotNull String booleanFieldName) {
        List<JSONValue> requirementObjectLst = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.PASSWORD_QUALITY_REQUIREMENTS.getFieldName());
        if (requirementObjectLst == null || requirementObjectLst.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PasswordQualityRequirement> requirements = new ArrayList<PasswordQualityRequirement>(requirementObjectLst.size());
        for (JSONValue requirementObjectValue : requirementObjectLst) {
            String description;
            JSONObject requirementObject;
            Boolean include;
            if (!(requirementObjectValue instanceof JSONObject) || (include = (requirementObject = (JSONObject)requirementObjectValue).getFieldAsBoolean(booleanFieldName)) == null || !include.booleanValue() || (description = requirementObject.getFieldAsString(REQUIREMENT_FIELD_DESCRIPTION)) == null) continue;
            String clientSideValidationType = requirementObject.getFieldAsString(REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_TYPE);
            LinkedHashMap<String, String> clientSideValidationProperties = new LinkedHashMap<String, String>();
            List<JSONValue> propertyValues = requirementObject.getFieldAsArray(REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_PROPERTIES);
            if (propertyValues != null) {
                for (JSONValue propertyValue : propertyValues) {
                    if (!(propertyValue instanceof JSONObject)) continue;
                    JSONObject propertyObject = (JSONObject)propertyValue;
                    String name = propertyObject.getFieldAsString(REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_PROPERTY_NAME);
                    String value = propertyObject.getFieldAsString(REQUIREMENT_FIELD_CLIENT_SIDE_VALIDATION_PROPERTY_VALUE);
                    if (name == null || value == null) continue;
                    clientSideValidationProperties.put(name, value);
                }
            }
            requirements.add(new PasswordQualityRequirement(description, clientSideValidationType, clientSideValidationProperties));
        }
        return requirements;
    }

    @Nullable
    public Boolean hasPasswordEncodedWithNonCurrentSettings() {
        return this.passwordPolicyStateObject.getFieldAsBoolean(PasswordPolicyStateJSONField.HAS_PASSWORD_ENCODED_WITH_NON_CURRENT_SETTINGS.getFieldName());
    }

    @NotNull
    public Map<String, List<String>> getNonCurrentPasswordStorageSchemeSettingsExplanations() {
        LinkedHashMap explanationsMap = new LinkedHashMap();
        List<JSONValue> values = this.passwordPolicyStateObject.getFieldAsArray(PasswordPolicyStateJSONField.NON_CURRENT_PASSWORD_STORAGE_SCHEME_SETTINGS_EXPLANATIONS.getFieldName());
        if (values != null) {
            for (JSONValue value : values) {
                JSONObject valueObject;
                String schemeName;
                if (!(value instanceof JSONObject) || (schemeName = (valueObject = (JSONObject)value).getFieldAsString(NON_CURRENT_ENCODING_FIELD_SCHEME)) == null) continue;
                ArrayList<String> explanationStrings = new ArrayList<String>();
                List<JSONValue> explanationValues = valueObject.getFieldAsArray(NON_CURRENT_ENCODING_FIELD_EXPLANATIONS);
                if (explanationValues != null) {
                    for (JSONValue explanationValue : explanationValues) {
                        if (!(explanationValue instanceof JSONString)) continue;
                        explanationStrings.add(((JSONString)explanationValue).stringValue());
                    }
                }
                explanationsMap.put(schemeName, explanationStrings);
            }
        }
        return Collections.unmodifiableMap(explanationsMap);
    }

    @Nullable
    private Date getDate(@NotNull PasswordPolicyStateJSONField field) {
        String stringValue = this.passwordPolicyStateObject.getFieldAsString(field.getFieldName());
        if (stringValue == null) {
            return null;
        }
        try {
            return StaticUtils.decodeRFC3339Time(stringValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @NotNull
    public String toString() {
        return this.passwordPolicyStateObject.toSingleLineString();
    }
}

